/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import okada.DCCON2;
import wrapper.StressSource;

public class StressChange
extends StressSource {
    static Matrix3d stress_change = new Matrix3d();
    static Vector3d normVector = new Vector3d();
    static Matrix3d sigma_tectonic = new Matrix3d();
    public static Vector3d vparalel = new Vector3d();
    public static Vector3d vperp = new Vector3d();
    static Matrix3d sigma = new Matrix3d();
    static Matrix3d insitu_stress = new Matrix3d();
    private static double[] press_coeff = new double[2];
    private static double PI8 = 0.01745329238474369;
    private static double rockdens = 2.3;
    public static double ss = 0.0;
    public static double sn = 0.0;
    public static double tow = 0.0;
    static float critstress = 0.0f;
    public static double CFF;
    public static double pf;

    public StressChange(double sh, double sH, double azimsh, double rockdens) {
        sigma_tectonic = new Matrix3d();
        Matrix3d teta = new Matrix3d();
        StressChange.sigma_tectonic.m00 = sh;
        StressChange.sigma_tectonic.m11 = sH;
        StressChange.sigma_tectonic.m22 = 1.0;
        double rot = azimsh;
        teta.rotZ(1.5707963267948966 - Math.PI * 2 * rot / 360.0);
        Matrix3d tetaT = new Matrix3d(teta);
        tetaT.transpose();
        sigma_tectonic.mul(sigma_tectonic, tetaT);
        sigma_tectonic.mul(teta, sigma_tectonic);
        StressChange.press_coeff[0] = 10000.0;
        StressChange.press_coeff[1] = 0.0;
    }

    public Vector3d getNormal(double azim, double dip) {
        Vector3d norm = new Vector3d();
        double ddip = 90.0 - dip;
        norm.z = Math.sin(ddip * PI8);
        double rh = Math.cos(ddip * PI8);
        double rotradians = 1.5707963267948966 - azim * PI8;
        norm.x = Math.cos(rotradians) * rh;
        norm.y = Math.sin(rotradians) * rh;
        return norm;
    }

    public static void stressCalculation(double depth, double azim, double dip, Matrix3d internalStress, double fricangle) {
        double sh = 0.35;
        double sH = 0.6;
        double azim_sh = 90.0;
        double pressure = 0.0;
        double frictionangle = fricangle * PI8;
        double coh = 0.0;
        double ssdrop = 0.0;
        StressChange s = new StressChange(sh, sH, azim_sh, rockdens);
        Vector3d norm = s.getNormal(azim, dip);
        Vector3d t = StressChange.getStress(norm, depth, azim, internalStress);
        pf = s.getProximityToFailure(t, norm, depth, pressure, frictionangle, coh, ssdrop);
        System.out.println("dip " + dip + " sn " + sn + " ss " + ss + " crict " + critstress + " " + norm.length() + "  prox failure " + pf);
        double ratio = ss / sn;
        System.out.println("ss/sn " + ratio);
    }

    public void StressDrop(Vector3d vperp, Vector3d vparalel, double sfricangle, double dfricangle, double G) {
        Vector3d u = new Vector3d();
        double inversemode = 1.0 / vparalel.length();
        u.scale(inversemode, vperp);
        double sn = vperp.length();
        double ss = vparalel.length();
        double myu = G;
        double stressdrop = sn * (Math.tan(sfricangle) - Math.tan(dfricangle)) / myu;
        Vector3d d = new Vector3d();
        d.scale(stressdrop, u);
    }

    public double getProximityToFailure(Vector3d t, Vector3d norm, double depth, double p, double frictionangle, double c, double ssdrop) {
        sn = t.dot(norm);
        vperp.scale(sn, norm);
        vparalel.sub(t, vperp);
        ss = vparalel.length() - ssdrop;
        sn -= p;
        if (Math.abs(sn) > 0.001) {
            critstress = (float)(Math.tan(frictionangle) * sn);
            return (ss - (double)critstress) / (double)Math.abs(critstress);
        }
        if (c > 0.001) {
            return (ss - (double)critstress) / c;
        }
        return ss;
    }

    public static void ColoumbStressChange(double ShearChange, double normChange) {
        Matrix3d stressTensor = new Matrix3d(stress_change);
        double skk = stressTensor.m00 + stressTensor.m11 + stressTensor.m22;
        double k_skel = DCCON2.E / (3.0 * (1.0 - 2.0 * DCCON2.MYU));
        double kw = 22000.0;
        double a = 1.0 - k_skel / kw;
        double B = 1.0 / k_skel / (1.0 / k_skel + DCCON2.phi / a * (1.0 / kw));
        double u = 0.9;
        CFF = ShearChange + u * (normChange - B * skk / 3.0);
    }

    public static Vector3d getStress(Vector3d norm, double depth, double azim, Matrix3d internalStress) {
        StressChange.press_coeff[1] = 0.0;
        Matrix3d sigma = StressChange.calcSigma(depth, azim, internalStress);
        Vector3d v = new Vector3d();
        int i = 0;
        while (i < 3) {
            Vector3d row = new Vector3d();
            sigma.getRow(i, row);
            double prod = row.dot(norm);
            switch (i) {
                case 0: {
                    v.x = prod;
                }
                case 1: {
                    v.y = prod;
                }
                case 2: {
                    v.z = prod;
                }
            }
            ++i;
        }
        return v;
    }

    public static Matrix3d calcSigma(double depth, double azim, Matrix3d internalStress) {
        Matrix3d ts = new Matrix3d(sigma_tectonic);
        StressChange.press_coeff[0] = 10000.0;
        double p = -(press_coeff[0] * Math.abs(depth) + press_coeff[1]);
        ts.mul(rockdens * Math.abs(depth) * 9.8 * 1000.0);
        insitu_stress.add(ts, new Matrix3d(p, 0.0, 0.0, 0.0, p, 0.0, 0.0, 0.0, p));
        stress_change = StressChange.stressTensor(azim, internalStress);
        Matrix3d final_stress = new Matrix3d();
        final_stress.add(stress_change, insitu_stress);
        return final_stress;
    }

    public static Matrix3d stressTensor(double azim, Matrix3d internalStress) {
        Matrix3d R = new Matrix3d();
        R.m00 = R.m11 = Math.cos(azim);
        R.m22 = 1.0;
        R.m01 = Math.sin(azim);
        R.m10 = -1.0 * R.m01;
        R.m21 = 0.0;
        R.m20 = 0.0;
        R.m12 = 0.0;
        R.m02 = 0.0;
        Matrix3d Rt = new Matrix3d();
        Rt.transpose(R);
        Matrix3d stress_change = new Matrix3d();
        stress_change.mul(internalStress, R);
        stress_change.mul(Rt, stress_change);
        return stress_change;
    }
}

