/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.Vector;
import tno.geoenergy.tableutil.TableFD;
import wrapper.StressST;

public class StressSTData
extends TableFD {
    Vector<StressST> stressSTContainer = new Vector();
    public static String[] colNames = new String[]{"ID", "I", "J", "TIME", "X", "Y", "Z", "S1", "S2", "S3", "STNORMAL", "STFAV", "p1x", "p1y", "p1z", "p2x", "p2y", "p2z", "p3x", "p3y", "p3z"};
    public static int[] colTypes = new int[]{TableFD.INT, TableFD.INT, TableFD.INT, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE};
    private static final boolean[] editable = new boolean[18];

    public Vector<StressST> getStressSTContainer() {
        return this.stressSTContainer;
    }

    @Override
    public int[] getColTypes() {
        return colTypes;
    }

    @Override
    public String[] getColNames() {
        return colNames;
    }

    @Override
    public boolean[] getEditable() {
        return editable;
    }

    @Override
    public Vector[] getCategories() {
        return CATEGORIES;
    }

    public StressSTData(String fileName) {
        super(fileName, TableFD.ASCII);
    }

    public StressSTData() {
        this.setReadwritemode(TableFD.ASCII);
    }

    public int add(StressST se) {
        this.stressSTContainer.add(se);
        return this.stressSTContainer.size() - 1;
    }

    public StressST get(int i) {
        return this.stressSTContainer.get(i);
    }

    public void convert2Data() {
        String[][] s = new String[this.stressSTContainer.size()][this.getColNames().length];
        this.setData(s);
        float cummoment = 0.0f;
        int i = 0;
        while (i < this.stressSTContainer.size()) {
            boolean j = false;
            StressST se = this.stressSTContainer.get(i);
            s[i][0] = "" + se.getId();
            s[i][1] = "" + se.getI();
            s[i][2] = "" + se.getJ();
            s[i][3] = "" + se.getTime();
            s[i][4] = "" + se.getX().x;
            s[i][5] = "" + se.getX().y;
            s[i][6] = "" + se.getX().z;
            s[i][7] = "" + se.getStresses().x;
            s[i][8] = "" + se.getStresses().y;
            s[i][9] = "" + se.getStresses().z;
            s[i][10] = "" + se.getStfav();
            s[i][11] = "" + se.getStnormal();
            s[i][12] = "" + se.getP1().x;
            s[i][13] = "" + se.getP1().y;
            s[i][14] = "" + se.getP1().z;
            s[i][15] = "" + se.getP2().x;
            s[i][16] = "" + se.getP2().y;
            s[i][17] = "" + se.getP2().z;
            s[i][18] = "" + se.getP3().x;
            s[i][19] = "" + se.getP3().y;
            s[i][20] = "" + se.getP3().z;
            ++i;
        }
    }

    public void SaveFile(String filename) {
        this.convert2Data();
        this.setFilename(filename);
        super.SaveFile();
    }

    public static void main(String[] args) {
    }
}

