/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import okada.DCCON0;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.TectonicStress;

public class StressSource {
    double height = 0.0;
    public static int SOURCE_POINT = 1;
    public static int SOURCE_RECTANGULAR = 2;
    public static int IJ11 = 0;
    public static int IJ22 = 1;
    public static int IJ33 = 2;
    public static int IJ12 = 0;
    public static int IJ13 = 1;
    public static int IJ23 = 2;
    Vector3d x = new Vector3d();
    double azim = 0.0;
    double dip = 0.0;
    boolean checkDist = false;
    public static StressSource STRESSSOURCE = null;
    Vector3d vstrike = new Vector3d();
    Vector3d vdip = new Vector3d();
    Vector3d vnormal = new Vector3d();
    double length = 0.0;
    double width = 0.0;
    double pf = 0.0;
    Vector3d u = new Vector3d();
    Vector3d final_u = new Vector3d();
    boolean failed_ruptureevent = false;
    double volstrain = 0.0;
    double sh = TectonicStress.SHMIN;
    double sH = TectonicStress.SHMAX;
    double azim_sh = 90.0;
    double rockdens = 2.3;
    double[] press_coeff = new double[2];
    Vector3d output_u = new Vector3d();
    Vector3d output_eii = new Vector3d();
    Vector3d output_eij = new Vector3d();
    Vector3d output_sii = new Vector3d();
    Vector3d output_sij = new Vector3d();
    Matrix3d stress_change = new Matrix3d();
    Matrix3d tect_stress = new Matrix3d();
    Matrix3d stress_tensor_initial = new Matrix3d();
    Vector3d SS = new Vector3d();
    Vector3d SN = new Vector3d();
    public double sfric = 37.0;
    public double dfric = 33.0;
    public Vector3d rupture_u = new Vector3d();
    public Vector3d event_u = new Vector3d();
    public double snscalar;
    public double ssscalar;
    public double pressure = 0.0;
    public double stressdrop = 0.0;
    public double cs = 1.0E38;
    public double dcs = 0.0;

    public Vector3d getX() {
        return this.x;
    }

    public boolean isCheckDist() {
        return this.checkDist;
    }

    public void setCheckDist(boolean checkDist) {
        this.checkDist = checkDist;
    }

    public void clearRupture_u() {
        this.rupture_u.x = 0.0;
        this.rupture_u.y = 0.0;
        this.rupture_u.z = 0.0;
    }

    public void clearEvent_u() {
        this.event_u.x = 0.0;
        this.event_u.y = 0.0;
        this.event_u.z = 0.0;
    }

    public static Vector3d[][] ObSameAsSource(double x, double y, double depth, double length, double width, int NX, int NY) {
        Vector3d[][] OP_array = new Vector3d[NX][NY];
        double startx = x - 0.5 * length;
        double starty = y - 0.5 * width;
        double dx = length / (double)NX;
        double dy = width / (double)NY;
        double height = dx;
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                Vector3d xx = new Vector3d();
                xx.x = startx + ((double)i + 0.5) * dx;
                xx.y = starty + ((double)j + 0.5) * dy;
                xx.z = -depth;
                OP_array[i][j] = xx;
                ++j;
            }
            ++i;
        }
        return OP_array;
    }

    public void init_v(double azim, double dip) {
        this.vdip.z = (float)Math.sin(dip * Math.PI / 180.0);
        float rh = (float)Math.cos(dip * Math.PI / 180.0);
        float rotradians = (float)(1.5707963267948966 - Math.PI * 2 * azim / 360.0);
        this.vdip.x = (float)Math.cos(rotradians) * rh;
        this.vdip.y = (float)Math.sin(rotradians) * rh;
        dip = 90.0 - dip;
        this.vnormal.z = -((float)Math.sin(dip * Math.PI / 180.0));
        rh = (float)Math.cos(dip * Math.PI / 180.0);
        this.vnormal.x = (float)Math.cos(rotradians) * rh;
        this.vnormal.y = (float)Math.sin(rotradians) * rh;
        this.vstrike = new Vector3d(this.vnormal);
        this.vstrike.cross(this.vdip, this.vnormal);
    }

    public void ActivateSource() {
        if (STRESSSOURCE == this) {
            return;
        }
        STRESSSOURCE = this;
        this.ActivateStressSource();
    }

    public void ActivateStressSource() {
        System.out.println(" FATAL ERROR ActivateStressSource() SHOULD BE IMPLEMENTED IN CLASS");
        System.exit(0);
    }

    public void calculateAtObservation(Vector3d o) {
        System.out.println(" FATAL ERROR calculateAtObservation() SHOULD BE IMPLEMENTED IN CLASS");
        System.exit(0);
    }

    public static void setStressParameters(double E, double v) {
        DCCON0.E = E;
        DCCON0.v = v;
        DCCON0.LAMBDA = E * v / ((1.0 + v) * (1.0 - 2.0 * v));
        DCCON0.MYU = E / (2.0 * (1.0 + v));
        DCCON0.ALPHA = (DCCON0.LAMBDA + DCCON0.MYU) / (DCCON0.LAMBDA + 2.0 * DCCON0.MYU);
    }

    public void getCumulativeOutput(Vector3d u, Vector3d eii, Vector3d eij, Vector3d sii, Vector3d sij, Matrix3d stress_change) {
        u.add(this.output_u);
        eii.add(this.output_eii);
        eij.add(this.output_eij);
        sii.add(this.output_sii);
        sij.add(this.output_sij);
        stress_change.add(this.stress_change);
    }

    public static void transformLocal2Global(double azim, Matrix3d localtensor) {
        Matrix3d R = new Matrix3d();
        double f = Math.PI / 180;
        R.m00 = R.m11 = Math.cos(azim * f);
        R.m22 = 1.0;
        R.m01 = Math.sin(azim * f);
        R.m10 = -1.0 * R.m01;
        R.m21 = 0.0;
        R.m20 = 0.0;
        R.m12 = 0.0;
        R.m02 = 0.0;
        Matrix3d Rt = new Matrix3d();
        Rt.transpose(R);
        Matrix3d globaltensor = new Matrix3d();
        globaltensor.mul(localtensor, R);
        globaltensor.mul(Rt, globaltensor);
        localtensor.m00 = globaltensor.m00;
        localtensor.m11 = globaltensor.m11;
        localtensor.m22 = globaltensor.m22;
        localtensor.m01 = localtensor.m10 = globaltensor.m01;
        localtensor.m02 = localtensor.m20 = globaltensor.m20;
        localtensor.m12 = localtensor.m21 = globaltensor.m21;
    }

    public static void transformLocal2Global(double azim, Vector3d diag, Vector3d deviatoric) {
        Matrix3d g = new Matrix3d();
        g.m00 = diag.x;
        g.m11 = diag.y;
        g.m22 = diag.z;
        g.m01 = g.m10 = deviatoric.x;
        g.m02 = g.m20 = deviatoric.y;
        g.m12 = g.m21 = deviatoric.z;
        StressSource.transformLocal2Global(azim, g);
        diag.x = g.m00;
        diag.y = g.m11;
        diag.z = g.m22;
        deviatoric.x = g.m01;
        deviatoric.y = g.m02;
        deviatoric.z = g.m12;
    }

    public void copyStressChange() {
        this.stress_change.m00 = this.output_sii.x;
        this.stress_change.m11 = this.output_sii.y;
        this.stress_change.m22 = this.output_sii.z;
        this.stress_change.m01 = this.stress_change.m10 = this.output_sij.x;
        this.stress_change.m02 = this.stress_change.m20 = this.output_sij.y;
        this.stress_change.m12 = this.stress_change.m21 = this.output_sij.z;
    }

    public void rotateOutputGetStressChangeTensor() {
        System.out.println(" FATAL ERROR rotateOutputGetStressChangeTensor() SHOULD BE IMPLEMENTED IN CLASS");
        System.exit(0);
    }

    public void calculate(ObservationPoint op) {
        op.calculate(this);
    }

    public void calculate(ObservationPointData opd) {
        int j = 0;
        while (j < opd.size()) {
            ObservationPoint op = opd.get(j);
            op.calculate(this);
            ++j;
        }
    }

    public void calculateNotInspected(ObservationPointData opd, int[] inspectedpatch) {
        boolean type = false;
        int j = 0;
        while (j < opd.size()) {
            if (inspectedpatch[j] == -1) {
                ObservationPoint op = opd.get(j);
                op.calculate(this);
            }
            ++j;
        }
    }

    public void calculateInspected(ObservationPointData opd, int[] inspectedpatch_ss_opd, int length) {
        boolean type = false;
        int i = 0;
        while (i < length) {
            if (inspectedpatch_ss_opd[i] > -1) {
                ObservationPoint op = opd.get(inspectedpatch_ss_opd[i]);
                op.calculate(this);
            }
            ++i;
        }
    }

    public void final_u2u() {
        this.u = new Vector3d(this.final_u);
    }
}

