/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Vector3d;
import okada.DCCON2;
import wrapper.ObservationPointData;
import wrapper.StressSource;

public class StressSourceData
extends Vector {
    public StressSourceData() {
    }

    public StressSourceData(StressSourceData sd) {
        int i = 0;
        while (i < sd.size()) {
            this.add(sd.get(i));
            ++i;
        }
    }

    public void setRockDens(double rockdens) {
        int i = 0;
        while (i < this.size()) {
            this.get((int)i).rockdens = rockdens;
            ++i;
        }
    }

    public StressSourceData(StressSourceData sd, int n) {
        int i = 0;
        while (i < n) {
            this.add(sd.get(i));
            ++i;
        }
    }

    public void final_u2u() {
        int i = 0;
        while (i < this.size()) {
            this.get(i).final_u2u();
            ++i;
        }
    }

    public void clearRupture_u() {
        int i = 0;
        while (i < this.size()) {
            this.get(i).clearRupture_u();
            ++i;
        }
    }

    public void clearEvent_u() {
        int i = 0;
        while (i < this.size()) {
            this.get(i).clearEvent_u();
            ++i;
        }
    }

    public double calculateMoment(Vector3d ruptureCentroid) {
        double m = 0.0;
        double d = 0.0;
        double sumd = 0.0;
        ruptureCentroid.scale(0.0);
        Vector3d scaledmom = new Vector3d();
        int ncount = 0;
        int i = 0;
        while (i < this.size()) {
            ++ncount;
            d = this.get((int)i).rupture_u.length();
            sumd += d;
            m += d * this.get((int)i).length * this.get((int)i).width;
            scaledmom.scale(d, this.get((int)i).x);
            ruptureCentroid.add(scaledmom);
            ++i;
        }
        ruptureCentroid.scale(1.0 / sumd);
        return m *= DCCON2.MYU;
    }

    public double calculateMoment2(int indexOfSeismicEvent, int[] indexevent, Vector3d ruptureCentroid) {
        double m = 0.0;
        double d = 0.0;
        double sumd = 0.0;
        ruptureCentroid.scale(0.0);
        Vector3d scaledmom = new Vector3d();
        int i = 0;
        while (i < this.size()) {
            if (indexevent[i] == indexOfSeismicEvent) {
                d = this.get((int)i).event_u.length();
                sumd += d;
                m += d * this.get((int)i).length * this.get((int)i).width;
                scaledmom.scale(d, this.get((int)i).x);
                ruptureCentroid.add(scaledmom);
            }
            ++i;
        }
        ruptureCentroid.scale(1.0 / sumd);
        return m *= DCCON2.MYU;
    }

    public double calculateRuptureArea(int indexOfSeismicEvent, int[] indexevent) {
        double a = 0.0;
        int ncount = 0;
        int i = 0;
        while (i < this.size()) {
            ++ncount;
            if (indexevent[i] == indexOfSeismicEvent) {
                a += this.get((int)i).length * this.get((int)i).width;
            }
            ++i;
        }
        return a;
    }

    public double calculateDisplacement(double area, double moment) {
        double d = moment / (DCCON2.MYU * area);
        return d;
    }

    public double calculateRuptureArea() {
        double a = 0.0;
        int ncount = 0;
        int i = 0;
        while (i < this.size()) {
            ++ncount;
            if (this.get((int)i).rupture_u.length() > 1.0E-30) {
                System.out.println("area of rupture : " + a);
                a += this.get((int)i).length * this.get((int)i).width;
            }
            ++i;
        }
        return a;
    }

    @Override
    public StressSource get(int i) {
        return (StressSource)super.get(i);
    }

    public void calculateAll(ObservationPointData opd) {
        int i = 0;
        while (i < this.size()) {
            StressSource ss = this.get(i);
            ss.calculate(opd);
            ++i;
        }
    }

    public void saveCsv(String filename) {
        String[] getColNames = new String[]{"X", "Y", "Z", "strength"};
        StringBuffer Strbuf = new StringBuffer();
        File myfile = new File(filename);
        FileOutputStream StreamOut = null;
        try {
            StreamOut = new FileOutputStream(filename);
        }
        catch (IOException e) {
            System.out.println("Error opening output file: " + filename);
        }
        double[] nrs = new double[getColNames.length];
        int i = 0;
        while (i < nrs.length) {
            if (i > 0) {
                Strbuf.append(",");
            }
            Strbuf.append(getColNames[i]);
            ++i;
        }
        Strbuf.append("\n");
        int k = 0;
        while (k < this.size()) {
            StressSource ss = this.get(k);
            double x = ss.x.x;
            double y = ss.x.y;
            double z = ss.x.z;
            double strength = ss.volstrain;
            try {
                Strbuf.append(String.valueOf(x) + "," + y + "," + z + "," + strength + "\n");
            }
            catch (NumberFormatException er) {
                break;
            }
            catch (NullPointerException en) {
                break;
            }
            String Str = Strbuf.toString();
            byte[] byteDataOut = Str.getBytes();
            Strbuf = new StringBuffer();
            try {
                StreamOut.write(byteDataOut);
            }
            catch (IOException e) {
                System.out.println("Error writing to output file " + filename);
            }
            ++k;
        }
        try {
            StreamOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }
}

