/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.Random;
import java.util.logging.Logger;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import tno.geoenergy.tableutil.TableFD;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.PatchDislocation;
import wrapper.PatchProblem;
import wrapper.PatchProblemData;
import wrapper.PatchStack;
import wrapper.PressureWell;
import wrapper.SeismicEvent;
import wrapper.SeismicEventData;
import wrapper.StressST;
import wrapper.StressSTData;
import wrapper.StressSource;
import wrapper.StressSourceData;
import wrapper.TectonicStress;

public class StressSourceDataRupture
extends StressSourceData {
    public static final double OKADASTRESSSIGN = -1.0;
    private static final int NSUBEVENTMAX = 100;
    public static int ITOTALPATCH = 0;
    private static final int MAXTOTALPATCHCHECK = 10000;
    private static double MWTRESHOLD = -100.0;
    public static int MAXTOTALPATCH = 10000;
    public static int MAXPATCHSTEP = 40;
    Vector3d ssOld = new Vector3d();
    Vector3d snOld = new Vector3d();
    double pfOld = 0.0;
    Vector3d U_old = new Vector3d();
    Vector3d ssNew = new Vector3d();
    Vector3d snNew = new Vector3d();
    double pfNew = 0.0;
    Vector3d U_new = new Vector3d();
    Matrix3d sc = new Matrix3d();
    int nx;
    int ny;
    ObservationPointData opd = null;
    SeismicEventData sed = new SeismicEventData();
    PatchProblemData ppd = new PatchProblemData();
    StressSTData sstd = new StressSTData();
    int[] indexevent = null;
    int[] inspectedpatch = null;
    int[] inspectedpatch_ss_opd = null;
    int[] didnotconverge = null;
    int Ninspected = 0;
    private double thistime;
    private static Logger logger = Logger.getLogger(StressSourceDataRupture.class.getName());
    public static Random ran = new Random();

    public static void setMWTRESHOLD(double mWTRESHOLD) {
        MWTRESHOLD = mWTRESHOLD;
    }

    public ObservationPointData getOpd() {
        return this.opd;
    }

    public void generateNoiseFriction(double value) {
        int i = 0;
        while (i < this.size()) {
            double diffric = this.get((int)i).sfric - this.get((int)i).dfric;
            double dev = value * (ran.nextDouble() - 0.5);
            this.get((int)i).sfric += dev;
            this.get((int)i).dfric = this.get((int)i).sfric - diffric;
            ++i;
        }
    }

    public void generateNoiseFriction(double noise1, double noise2, double sfric1, double sfric2) {
        double zstart = this.get((int)(this.size() - 1)).x.z;
        double zend = this.get((int)0).x.z;
        double noise_s = (noise2 - noise1) / (zend - zstart);
        double sfric_s = (sfric2 - sfric1) / (zend - zstart);
        double dev = 0.0;
        double value = 0.0;
        int i = 0;
        while (i < this.size()) {
            value = noise1 + (this.get((int)i).x.z - zstart) * noise_s;
            this.get((int)i).sfric = sfric1 + (this.get((int)i).x.z - zstart) * sfric_s;
            dev = value * ran.nextDouble();
            this.get((int)i).sfric += dev - 0.5 * value;
            this.get((int)i).dfric += 0.0;
            ++i;
        }
    }

    public void generateNoiseFrictionX(double value, int randomseed) {
        Random ran = new Random();
        ran.setSeed(randomseed);
        int i = 0;
        while (i < this.nx) {
            double dev = value * ran.nextDouble();
            int j = 0;
            while (j < this.ny) {
                int iseed = this.getIseed(i, j);
                this.get((int)iseed).sfric += dev - 0.5 * value;
                this.get((int)iseed).dfric += 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void generateNoiseFrictionX2(double value, double horscale, int randomseed) {
        Random ran2 = new Random();
        ran2.setSeed(randomseed);
        int i = 0;
        while (i < this.nx) {
            double dev = value * ran2.nextDouble();
            int j = 0;
            while (j < this.ny) {
                int iseed = this.getIseed(i, j);
                double dev2 = horscale * (value * ran.nextDouble() - 0.5 * value);
                this.get((int)iseed).sfric += dev - 0.5 * value + dev2;
                this.get((int)iseed).dfric += 0.0;
                ++j;
            }
            ++i;
        }
    }

    public StressSourceDataRupture(StressSourceData sd, int nx, int ny, int nobs) {
        super(sd, nx * ny);
        this.nx = nx;
        this.ny = ny;
        this.indexevent = new int[nx * ny];
        this.didnotconverge = new int[nx * ny];
        this.inspectedpatch = new int[nx * ny];
        this.inspectedpatch_ss_opd = new int[nx * ny];
        this.opd = new ObservationPointData(this, nobs);
    }

    public ObservationPointData getObservationData() {
        return this.opd;
    }

    public void setSfricDfricConstant(double sfric, double dfric) {
        int i = 0;
        while (i < this.size()) {
            this.get((int)i).sfric = sfric;
            this.get((int)i).dfric = dfric;
            ++i;
        }
    }

    public void updateTotalStressPF(int i) {
        StressSource ss = this.get(i);
        ObservationPoint op = this.opd.get(i);
        Matrix3d sc = new Matrix3d(op.stress_change);
        sc.mul(-1.0);
        ss.stress_tensor_initial.add(ss.tect_stress, sc);
        double fricangle = ss.sfric;
        if (ss.failed_ruptureevent) {
            fricangle = ss.dfric;
        }
        TectonicStress.stressCalculation(ss.azim, ss.dip, ss.stress_tensor_initial, fricangle, ss.vnormal, ss.pressure, ss.stressdrop);
        ss.pf = TectonicStress.pf;
        ss.SS.scale(1.0, TectonicStress.vparalel);
        ss.SN.scale(1.0, TectonicStress.vperp);
        ss.snscalar = TectonicStress.sn;
        ss.ssscalar = TectonicStress.ss;
        fricangle = ss.sfric;
        if (op.cs > 1.0E30) {
            op.cs = ss.ssscalar - Math.tan(fricangle * Math.PI / 180.0) * ss.snscalar;
        }
        ss.dcs = ss.ssscalar - Math.tan(fricangle * Math.PI / 180.0) * ss.snscalar;
        op.setPf(TectonicStress.pf, ss.pressure, ss.dcs);
    }

    public void updateTotalStressPF() {
        int i = 0;
        while (i < this.size()) {
            this.updateTotalStressPF(i);
            ++i;
        }
    }

    public void updateTotalStressPFFast() {
        int i = 0;
        while (i < this.size()) {
            if (this.inspectedpatch[i] > -1) {
                this.updateTotalStressPF(i);
            }
            ++i;
        }
    }

    public void setAllHealed() {
        int i = 0;
        while (i < this.size()) {
            StressSource ss = this.get(i);
            ss.failed_ruptureevent = false;
            ++i;
        }
    }

    public void getTectonicStresses() {
        int i = 0;
        while (i < this.size()) {
            StressSource ss = this.get(i);
            double depth = -ss.x.z;
            Matrix3d temp = new Matrix3d();
            ss.tect_stress = temp = TectonicStress.TectStress(ss.sh, ss.sH, TectonicStress.ShminAzim, ss.rockdens, depth);
            ++i;
        }
    }

    public void outputStressState() {
        int i = 0;
        while (i < this.size()) {
            StressSource ss = this.get(i);
            System.out.println("number " + i + "  DISL initial    " + ss.u + "  ss " + ss.ssscalar + " sn  " + ss.snscalar + "  pf before iterate" + ss.pf);
            ++i;
        }
    }

    public void checkPf(int iter) {
        System.out.println("checking another iteration " + iter);
        boolean stillfailing = false;
        int i = 0;
        while (i < this.size()) {
            StressSource ss = this.get(i);
            ObservationPoint op = this.opd.get(i);
            if (ss.pf >= PatchDislocation.ITER_TRESHOLD) {
                stillfailing = true;
                double ssdif = ss.ssscalar;
                System.out.println("before failure patch " + i + "  DISL initial    " + ss.u + "  ss " + ss.ssscalar + " sn  " + ss.snscalar + "  pf before  iterate " + ss.pf);
                this.performIteration(i);
                System.out.println("after failure patch " + i + "  DISL initial    " + ss.u + "  ss " + ss.ssscalar + " sn  " + ss.snscalar + "  pf after iterate " + ss.pf);
                System.out.println("effective change of SS [bar] " + (ss.ssscalar - ssdif) / 100000.0);
            }
            ++i;
        }
        if (stillfailing) {
            if (iter < 100) {
                this.checkPf(++iter);
            } else {
                System.out.println("routine did not converge in " + iter + " iterations");
            }
        } else {
            System.out.println("iteration converged in #iterations " + iter);
        }
    }

    public int getIseed(int i, int j) {
        return i * this.ny + j;
    }

    private boolean progressRuptureStack(PatchStack ps, boolean updateperm, double time, SeismicEvent se, int icount) {
        if (icount > MAXPATCHSTEP || ITOTALPATCH > MAXTOTALPATCH) {
            return true;
        }
        int i = ps.getNextIndexFromStack(true);
        if (this.didnotconverge[i] != -1) {
            logger.warning(" handling patch which has been problematic before " + i);
        }
        while (i > -1) {
            boolean okfail;
            if ((ITOTALPATCH + 1) % 100 == 0) {
                System.out.print("p.");
            }
            if (ITOTALPATCH > MAXTOTALPATCH) {
                return true;
            }
            if (icount % 100 == 0) {
                logger.fine("iterating on patch " + i + "  x " + this.get((int)i).x + "  Nstack " + ps.NSTACK + " NTOTALADDED " + ps.NTOTALADDED);
            }
            ++icount;
            double scale = 1.0;
            int ievent = -1;
            int iseed = i / this.ny;
            int jseed = i - iseed * this.ny;
            StressSource ss = this.get(i);
            ObservationPoint op = this.opd.get(i);
            double dpfcriterium = ss.pf;
            dpfcriterium = Math.abs(ss.pf);
            boolean bl = okfail = this.indexevent[i] == -1 && ss.pf >= PatchDislocation.ITER_TRESHOLD || this.indexevent[i] != -1 && dpfcriterium >= PatchDislocation.ITER_TRESHOLD + 0.01;
            if (okfail) {
                updateperm = true;
                int ibak = this.getIbakIfor(iseed, jseed, -1);
                int ifor = this.getIbakIfor(iseed, jseed, 1);
                int jbak = this.getJbakJfor(iseed, jseed, -1);
                int jfor = this.getJbakJfor(iseed, jseed, 1);
                double ssorig = ss.ssscalar;
                double snorig = ss.snscalar;
                logger.finer(" patch (" + iseed + "," + jseed + ")   before iteration stress diag   DISL initial    " + ss.u + "  ss " + ss.ssscalar + " sn  " + ss.snscalar + "  pf before  iterate " + ss.pf + "  fluid pressure " + ss.pressure);
                if (se == null) {
                    se = new SeismicEvent(ss.x.x, ss.x.y, ss.x.z, time, 0.0, 0.0);
                    this.indexevent[i] = ievent = this.sed.add(se);
                } else {
                    this.indexevent[i] = this.sed.getSeismicEventContainer().size() - 1;
                }
                this.performIteration(i);
                logger.finest("after failure patch " + i + "  DISL initial    " + ss.u + "  ss " + ss.ssscalar + " sn  " + ss.snscalar + "  pf after iterate " + ss.pf);
                logger.finer(" patch (" + iseed + "," + jseed + ")  " + ss.x + "  effective change of SS [bar] " + (ss.ssscalar - ssorig) / 100000.0 + " for  SN change  " + (ss.snscalar - snorig) / 100000.0 + "  fluid pressure " + ss.pressure + "    after iteration stress determinant " + this.diag(ss.stress_tensor_initial));
                boolean[] ok = new boolean[4];
                int ii = 0;
                while (ii < 4) {
                    ok[ii] = true;
                    ++ii;
                }
                int inew = -1;
                inew = this.getIseed(ifor, jseed);
                if (this.indexevent[inew] != -1 && inew != i) {
                    ps.add2Stack(this.get(inew), inew);
                    ok[1] = false;
                }
                if (this.indexevent[inew = this.getIseed(ibak, jseed)] != -1 && inew != i) {
                    ps.add2Stack(this.get(inew), inew);
                    ok[0] = false;
                }
                if (this.indexevent[inew = this.getIseed(iseed, jbak)] != -1 && inew != i) {
                    ps.add2Stack(this.get(inew), inew);
                    ok[2] = false;
                }
                if (this.indexevent[inew = this.getIseed(iseed, jfor)] != -1 && inew != i) {
                    ps.add2Stack(this.get(inew), inew);
                    ok[3] = false;
                }
                inew = this.getIseed(ifor, jseed);
                if (ok[1] && inew != i) {
                    ps.add2Stack(this.get(inew), inew);
                }
                inew = this.getIseed(ibak, jseed);
                if (ok[0] && inew != i) {
                    ps.add2Stack(this.get(inew), inew);
                }
                inew = this.getIseed(iseed, jbak);
                if (ok[2] && inew != i) {
                    ps.add2Stack(this.get(inew), inew);
                }
                inew = this.getIseed(iseed, jfor);
                if (ok[3] && inew != i) {
                    ps.add2Stack(this.get(inew), inew);
                }
            }
            ++ITOTALPATCH;
            i = ps.getNextIndexFromStack(true);
        }
        return true;
    }

    private boolean progressRupture(int i, boolean updateperm, double time, SeismicEvent se) {
        boolean okfail;
        double scale = 1.0;
        int ievent = -1;
        int iseed = i / this.ny;
        int jseed = i - iseed * this.ny;
        StressSource ss = this.get(i);
        ObservationPoint op = this.opd.get(i);
        double dpfcriterium = ss.pf;
        dpfcriterium = Math.abs(ss.pf);
        boolean bl = okfail = this.indexevent[i] == -1 && ss.pf >= PatchDislocation.ITER_TRESHOLD || this.indexevent[i] != -1 && dpfcriterium >= PatchDislocation.ITER_TRESHOLD + 0.01;
        if (okfail) {
            updateperm = true;
            int ibak = Math.max(0, iseed - 1);
            int ifor = Math.min(iseed + 1, this.nx - 1);
            int jbak = Math.max(0, jseed - 1);
            int jfor = Math.min(jseed + 1, this.ny - 1);
            double ssorig = ss.ssscalar;
            double snorig = ss.snscalar;
            logger.finer(" patch (" + iseed + "," + jseed + ")   before iteration stress diag   DISL initial    " + ss.u + "  ss " + ss.ssscalar + " sn  " + ss.snscalar + "  pf before  iterate " + ss.pf);
            if (se == null) {
                se = new SeismicEvent(ss.x.x, ss.x.y, ss.x.z, time, 0.0, 0.0);
                this.indexevent[i] = ievent = this.sed.add(se);
            } else {
                this.indexevent[i] = this.sed.getSeismicEventContainer().size() - 1;
            }
            this.performIteration(i);
            logger.finest("after failure patch " + i + "  DISL initial    " + ss.u + "  ss " + ss.ssscalar + " sn  " + ss.snscalar + "  pf after iterate " + ss.pf);
            logger.finer(" patch (" + iseed + "," + jseed + ")  " + ss.x + "  effective change of SS [bar] " + (ss.ssscalar - ssorig) / 100000.0 + " for  SN change  " + (ss.snscalar - snorig) / 100000.0 + "    after iteration stress determinant " + this.diag(ss.stress_tensor_initial));
            if (jfor != jseed) {
                updateperm = this.progressRupture(this.getIseed(iseed, jfor), updateperm, time, se);
            }
            if (jbak != jseed) {
                updateperm = this.progressRupture(this.getIseed(iseed, jbak), updateperm, time, se);
            }
            if (ibak != iseed) {
                updateperm = this.progressRupture(this.getIseed(ibak, jseed), updateperm, time, se);
            }
            if (ifor != iseed) {
                updateperm = this.progressRupture(this.getIseed(ifor, jseed), updateperm, time, se);
            }
        }
        return updateperm;
    }

    private double diag(Matrix3d t) {
        return (t.m00 + t.m11 + t.m22) / 3.0;
    }

    public void performIteration(int i) {
        this.get((int)i).failed_ruptureevent = true;
        StressSource ss = this.get(i);
        ObservationPoint op = this.getObservationData().get(i);
        boolean problemconvergence = true;
        if (problemconvergence) {
            if (this.didnotconverge[i] == -1) {
                double d2;
                Vector3d alternative2SS = new Vector3d();
                Vector3d newnormal1 = new Vector3d();
                Vector3d newnormal2 = new Vector3d();
                Vector3d newnormal = new Vector3d();
                Vector3d oldnormal = TectonicStress.getNormal(ss.azim, ss.dip);
                double stfav1 = TectonicStress.getST(ss.stress_tensor_initial, null, 1, ss.sfric, newnormal1);
                double stfav2 = TectonicStress.getST(ss.stress_tensor_initial, null, -1, ss.sfric, newnormal2);
                double d1 = Math.abs(newnormal1.dot(oldnormal));
                newnormal = d1 > (d2 = Math.abs(newnormal2.dot(oldnormal))) ? newnormal1 : newnormal2;
                TectonicStress.getStress(newnormal, ss.stress_tensor_initial, alternative2SS);
                double rotangle = 0.0;
                while (problemconvergence && rotangle < 90.0) {
                    PatchDislocation.DislocationTry1(ss, alternative2SS, rotangle, op);
                    problemconvergence = PatchDislocation.DislocationIterate();
                    if (!problemconvergence) continue;
                    if (problemconvergence && rotangle < 0.001) {
                        MAXTOTALPATCH = ITOTALPATCH + 10000;
                        Vector3d traction = TectonicStress.getT();
                        PatchProblem pp = new PatchProblem(i, ss.x.x, ss.x.y, ss.x.z, this.thistime, traction.x, traction.y, traction.z);
                        this.ppd.add(pp);
                    }
                    rotangle += 5.0;
                }
                if (problemconvergence) {
                    this.didnotconverge[i] = 1;
                }
            } else {
                MAXTOTALPATCH = ITOTALPATCH + 10000;
            }
        }
        this.stressUpdate(i);
        this.updateTotalStressPF();
    }

    public void checkPfSeed(double time, double maxdist) {
        StressSource ss = null;
        boolean updateperm = false;
        boolean failed = true;
        SeismicEvent se = null;
        int iseed = -1;
        double maxproxfailure = 0.0;
        int i = 0;
        while (i < this.size()) {
            this.indexevent[i] = -1;
            ++i;
        }
        while (failed) {
            failed = false;
            maxproxfailure = PatchDislocation.ITER_TRESHOLD;
            i = 0;
            while (i < this.size()) {
                boolean okfail;
                ss = this.get(i);
                double offset = 0.0;
                double dpfcriterium = ss.pf;
                dpfcriterium = Math.abs(ss.pf);
                boolean bl = okfail = this.indexevent[i] == -1 && ss.pf >= PatchDislocation.ITER_TRESHOLD || this.indexevent[i] != -1 && dpfcriterium >= PatchDislocation.ITER_TRESHOLD + 0.01;
                if (okfail) {
                    failed = true;
                    if (dpfcriterium >= maxproxfailure) {
                        maxproxfailure = dpfcriterium;
                        iseed = i;
                    }
                }
                ++i;
            }
            if (!failed) continue;
            logger.fine("FINDING A PATCH TO FAIL " + iseed);
            ss = this.get(iseed);
            logger.finer("entering iteration for iseed " + iseed + "with pf " + ss.pf);
            updateperm = this.mindistRuptured(ss) < maxdist ? this.progressRupture(iseed, updateperm, time, se) : this.progressRupture(iseed, updateperm, time, null);
            logger.finest("performed rupture for iseed " + iseed + "  pf  " + ss.pf);
            int index = this.sed.getSeismicEventContainer().size() - 1;
            se = this.sed.get(index);
            double moment = this.calculateMoment(se.getRuptureCentroid());
            double area = this.calculateRuptureArea();
            se.setArea(area);
            se.setMoment(se.getMoment() + moment);
            se.calculateSI_MW();
            this.clearRupture_u();
        }
    }

    public void checkPfSeedStack(double time, double maxdist, PatchStack ps) {
        this.thistime = time;
        int icount = 0;
        StressSource ss = null;
        boolean updateperm = false;
        boolean failed = true;
        SeismicEvent se = null;
        int iseed = -1;
        double maxproxfailure = 0.0;
        int i = 0;
        while (i < this.size()) {
            this.indexevent[i] = -1;
            this.didnotconverge[i] = -1;
            ++i;
        }
        this.clearEvent_u();
        int ipass = 0;
        while (ipass < 2) {
            failed = true;
            int i2 = 0;
            while (i2 < this.size()) {
                this.didnotconverge[i2] = -1;
                ++i2;
            }
            while (failed && icount < 100) {
                ITOTALPATCH = 0;
                MAXTOTALPATCH = 10000;
                ++icount;
                ps.forecedCleanStack();
                System.out.println("new rupture event");
                failed = false;
                maxproxfailure = PatchDislocation.ITER_TRESHOLD;
                int ncandidate = 0;
                int i3 = 0;
                while (i3 < this.size()) {
                    boolean okfail;
                    ss = this.get(i3);
                    double offset = 0.0;
                    double dpfcriterium = ss.pf;
                    dpfcriterium = Math.abs(ss.pf);
                    boolean bl = okfail = this.indexevent[i3] == -1 && ss.pf >= PatchDislocation.ITER_TRESHOLD || this.indexevent[i3] != -1 && dpfcriterium >= PatchDislocation.ITER_TRESHOLD + 0.01;
                    if (okfail && dpfcriterium >= maxproxfailure && (ncandidate == 0 || Math.random() >= 0.0) && this.didnotconverge[i3] == -1) {
                        failed = true;
                        maxproxfailure = dpfcriterium;
                        iseed = i3;
                        ++ncandidate;
                    }
                    ++i3;
                }
                if (!failed) continue;
                ss = this.get(iseed);
                logger.fine("FOUND A PATCH TO FAIL " + iseed + " with pf " + ss.pf);
                if (this.didnotconverge[iseed] != -1) {
                    logger.warning(" handling patch which has been problematic before " + iseed);
                }
                ps.add2Stack(ss, iseed);
                updateperm = this.mindistRuptured(ss) < maxdist ? this.progressRuptureStack(ps, updateperm, time, se, 0) : this.progressRuptureStack(ps, updateperm, time, null, 0);
                logger.finest("performed rupture for iseed " + iseed + "  pf  " + ss.pf);
                int index = this.sed.getSeismicEventContainer().size() - 1;
                se = this.sed.get(index);
                double moment = this.calculateMoment2(index, this.indexevent, se.getRuptureCentroid());
                double area = this.calculateRuptureArea(index, this.indexevent);
                se.setArea(area);
                se.setMoment(moment);
                se.setD(this.calculateDisplacement(area, se.getMoment()));
                se.calculateSI_MW();
                this.clearRupture_u();
            }
            ++ipass;
        }
        if (se != null) {
            int index = this.sed.getSeismicEventContainer().size() - 1;
            if (se.MW < MWTRESHOLD) {
                this.sed.getSeismicEventContainer().removeElementAt(index);
            }
        }
        i = 0;
        while (i < this.size()) {
            ss = this.get(i);
            if (this.didnotconverge[i] != -1) {
                boolean okfail;
                double dpfcriterium = ss.pf;
                dpfcriterium = Math.abs(ss.pf);
                boolean bl = okfail = ss.pf >= PatchDislocation.ITER_TRESHOLD || this.indexevent[i] != -1 && dpfcriterium >= PatchDislocation.ITER_TRESHOLD + 0.01;
                if (okfail) {
                    logger.warning("unresolved problem finding U --> pf==0 for patch " + i);
                    Vector3d stresses = new Vector3d();
                    Vector3d p1 = new Vector3d();
                    Vector3d p2 = new Vector3d();
                    Vector3d p3 = new Vector3d();
                    double stfav = 0.0;
                    double stnormal = 0.0;
                    Vector3d normal = TectonicStress.getNormal(ss.azim, ss.dip);
                    TectonicStress.getEig(ss.stress_tensor_initial, p1, p2, p3, stresses);
                    Vector3d outputNormal = new Vector3d();
                    stnormal = TectonicStress.getST(ss.stress_tensor_initial, normal, 1, ss.sfric, outputNormal);
                    stfav = TectonicStress.getST(ss.stress_tensor_initial, null, 1, ss.sfric, outputNormal);
                    StressST st = new StressST(i, 0, 0, ss.x, this.thistime, stresses, p1, p2, p3, stnormal, stfav);
                    this.sstd.add(st);
                }
            }
            ++i;
        }
    }

    public double mindistRuptured(StressSource ss) {
        double mindist = 1.0E38;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                if (this.indexevent[i * this.ny + j] != -1) {
                    Vector3d dist = new Vector3d(ss.x);
                    dist.sub(this.get((int)i).x);
                    double d = dist.length();
                    if (d < mindist) {
                        mindist = d;
                    }
                }
                ++j;
            }
            ++i;
        }
        return mindist;
    }

    public boolean checkPfSeedFast(double time, double maxdist) {
        StressSource ss = null;
        boolean updateperm = false;
        boolean failed = true;
        boolean foundrupture = false;
        int iseed = -1;
        double maxproxfailure = 0.0;
        int i = 0;
        while (i < this.size()) {
            this.indexevent[i] = -1;
            this.inspectedpatch[i] = -1;
            this.Ninspected = 0;
            ++i;
        }
        SeismicEvent se = null;
        while (failed) {
            failed = false;
            maxproxfailure = PatchDislocation.ITER_TRESHOLD;
            int i2 = 0;
            while (i2 < this.size()) {
                ss = this.get(i2);
                double offset = 0.0;
                if (this.indexevent[i2] == -1 && ss.pf >= PatchDislocation.ITER_TRESHOLD || this.indexevent[i2] != -1 && Math.abs(ss.pf) >= PatchDislocation.ITER_TRESHOLD + 0.01) {
                    failed = true;
                    foundrupture = true;
                    if (ss.pf > maxproxfailure) {
                        maxproxfailure = ss.pf;
                        iseed = i2;
                    }
                }
                ++i2;
            }
            if (!failed) continue;
            logger.fine("FINDING A PATCH TO FAIL " + iseed + "  inspectedpatch " + this.inspectedpatch[iseed] + " index event " + this.indexevent[iseed]);
            ss = this.get(iseed);
            logger.finest("entering iteration for iseed " + iseed + "with pf " + ss.pf);
            updateperm = this.mindistRuptured(ss) < maxdist ? this.progressRuptureFast(iseed, updateperm, time, se) : this.progressRuptureFast(iseed, updateperm, time, null);
            logger.finer("performed rupture for iseed " + iseed);
            int index = this.sed.getSeismicEventContainer().size() - 1;
            se = this.sed.get(index);
            double moment = this.calculateMoment(se.getRuptureCentroid());
            double area = this.calculateRuptureArea();
            se.setArea(area);
            se.setMoment(se.getMoment() + moment);
            se.calculateSI_MW();
            this.stressUpdateFastEndSeed();
            this.clearRupture_u();
            this.updateTotalStressPF();
            logger.finest("performed rupture for iseed " + iseed);
        }
        return foundrupture;
    }

    public void checkPfSeedFastOld(double time) {
        StressSource ss = null;
        boolean updateperm = false;
        boolean failed = true;
        boolean foundrupture = false;
        int iseed = -1;
        double maxproxfailure = 0.0;
        while (failed) {
            failed = false;
            int i = 0;
            while (i < this.size()) {
                this.indexevent[i] = -1;
                this.inspectedpatch[i] = -1;
                this.Ninspected = 0;
                ++i;
            }
            maxproxfailure = PatchDislocation.ITER_TRESHOLD;
            i = 0;
            while (i < this.size()) {
                ss = this.get(i);
                double offset = 0.0;
                if (this.indexevent[i] != -1) {
                    offset = 0.01;
                }
                if (ss.pf > maxproxfailure + offset) {
                    failed = true;
                    foundrupture = true;
                    maxproxfailure = ss.pf;
                    iseed = i;
                }
                ++i;
            }
            if (!failed) continue;
            System.out.println("FINDING A PATCH TO FAIL " + iseed + "  inspectedpatch " + this.inspectedpatch[iseed] + " index event " + this.indexevent[iseed]);
            ss = this.get(iseed);
            System.out.println("entering iteration for iseed " + iseed + "with pf " + ss.pf);
            updateperm = this.progressRuptureFast(iseed, updateperm, time, null);
            System.out.println("performed rupture for iseed " + iseed);
            int index = this.sed.getSeismicEventContainer().size() - 1;
            SeismicEvent se = this.sed.get(index);
            double moment = this.calculateMoment(se.getRuptureCentroid());
            double area = this.calculateRuptureArea();
            se.setArea(area);
            se.setMoment(moment);
            se.calculateSI_MW();
            this.stressUpdateFastEndSeed();
            this.clearRupture_u();
            this.setAllHealed();
            this.updateTotalStressPF();
            System.out.println("performed rupture for iseed " + iseed);
        }
    }

    private boolean progressRuptureFast(int i, boolean updateperm, double time, SeismicEvent se) {
        boolean okfail;
        double scale = 1.0;
        int ievent = -1;
        int iseed = i / this.ny;
        int jseed = i - iseed * this.ny;
        StressSource ss = this.get(i);
        ObservationPoint op = this.opd.get(i);
        if (this.inspectedpatch[i] < 0) {
            this.addSStoInspected(i);
        }
        double dpfcriterium = ss.pf;
        dpfcriterium = Math.abs(ss.pf);
        boolean bl = okfail = this.indexevent[i] == -1 && ss.pf >= PatchDislocation.ITER_TRESHOLD || this.indexevent[i] != -1 && dpfcriterium >= PatchDislocation.ITER_TRESHOLD + 0.01;
        if (okfail) {
            if (se == null) {
                se = new SeismicEvent(ss.x.x, ss.x.y, ss.x.z, time, 0.0, 0.0);
                this.indexevent[i] = ievent = this.sed.add(se);
            } else {
                this.indexevent[i] = this.sed.getSeismicEventContainer().size() - 1;
            }
            updateperm = true;
            int ibak = Math.max(0, iseed - 1);
            int ifor = Math.min(iseed + 1, this.nx - 1);
            int jbak = Math.max(0, jseed - 1);
            int jfor = Math.min(jseed + 1, this.ny - 1);
            double ssorig = ss.ssscalar;
            double snorig = ss.snscalar;
            logger.finer("before failure patch " + i + "  DISL initial    " + ss.u + "  ss " + ssorig + " sn  " + snorig + "  pf before  iterate " + ss.pf);
            this.performIterationFast(i);
            logger.finer("after failure patch " + i + "  DISL initial    " + ss.u + "  ss " + ss.ssscalar + " sn  " + ss.snscalar + "  pf after iterate " + ss.pf);
            logger.finer(" patch (" + iseed + "," + jseed + ") + effective change of SS [bar] " + (ss.snscalar - ssorig) / 100000.0 + " for  SN change  " + (ss.snscalar - snorig) / 100000.0);
            updateperm = this.progressRuptureFast(this.getIseed(ibak, jseed), updateperm, time, se);
            updateperm = this.progressRuptureFast(this.getIseed(ifor, jseed), updateperm, time, se);
            updateperm = this.progressRuptureFast(this.getIseed(iseed, jfor), updateperm, time, se);
            updateperm = this.progressRuptureFast(this.getIseed(iseed, jbak), updateperm, time, se);
        }
        return updateperm;
    }

    private int getJbakJfor(int i, int j, int jstep) {
        boolean edge = false;
        boolean ok = false;
        int jtarget = j;
        while (!edge && !ok) {
            jtarget += jstep;
            jtarget = Math.max(0, jtarget);
            edge = (jtarget = Math.min(this.ny - 1, jtarget)) == 0 || jtarget == this.ny - 1;
            int ij = this.getIseed(i, jtarget);
            ok = true;
            boolean bl = ok = this.didnotconverge[ij] == -1;
        }
        if (ok) {
            return jtarget;
        }
        return j;
    }

    private int getIbakIfor(int i, int j, int istep) {
        boolean edge = false;
        boolean ok = false;
        int itarget = i;
        while (!edge && !ok) {
            itarget += istep;
            itarget = Math.max(0, itarget);
            edge = (itarget = Math.min(this.nx - 1, itarget)) == 0 || itarget == this.nx - 1;
            int ij = this.getIseed(itarget, j);
            ok = true;
            boolean bl = ok = this.didnotconverge[ij] == -1;
        }
        if (ok) {
            return itarget;
        }
        return i;
    }

    public void performIterationFast(int i) {
        this.get((int)i).failed_ruptureevent = true;
        StressSource ss = this.get(i);
        ObservationPoint op = this.getObservationData().get(i);
        PatchDislocation.DislocationTry1(ss, null, 0.0, op);
        PatchDislocation.DislocationIterate();
        this.stressUpdateFast(i);
        this.updateTotalStressPFFast();
    }

    public void performIterationOld(int i) {
        this.get((int)i).failed_ruptureevent = true;
        StressSource ss = this.get(i);
        ObservationPoint op = this.getObservationData().get(i);
        PatchDislocation.DislocationTry1(ss, null, 0.0, op);
        PatchDislocation.DislocationIterate();
        this.stressUpdate(i);
        this.updateTotalStressPF();
    }

    public void writeSeismicEvents(double refx, double refy, String basename) {
        this.sed.setFilename(String.valueOf(basename) + "seismicevents.csv");
        this.sed.convert2Data((float)refx, (float)refy);
        this.sed.setReadwritemode(TableFD.CSV);
        this.sed.SaveFile();
    }

    public void writePatchProblems(String basename) {
        this.ppd.setFilename(String.valueOf(basename) + "patchProblems.txt");
        this.ppd.convert2Data();
        this.ppd.SaveFile();
        this.sstd.setFilename(String.valueOf(basename) + "patchstdata.txt");
        this.sstd.convert2Data();
        this.sstd.SaveFile();
    }

    public void plotSectionXZ(String basename, String subdirname, double xmin, double xmax, double y, double zmin, int loadnumber, StressSourceData additional) {
        Vector3d xzs = new Vector3d(xmin, y, zmin);
        System.out.println(" plotsectionXZ  start " + xzs.toString());
        Vector3d xze = new Vector3d(xmax, y, 0.0);
        System.out.println(" plotsectionXZ  end " + xze.toString());
        ObservationPointData opdlocal = new ObservationPointData();
        ObservationPoint[][] gopXZ = ObservationPoint.getObservationPointArray(xzs, xze, ObservationPoint.IDIRXZ, 20, 80, opdlocal);
        this.final_u2u();
        this.calculateAll(opdlocal);
        if (additional != null) {
            additional.calculateAll(opdlocal);
        }
        ObservationPointData.outputPlane(gopXZ, ObservationPoint.IDIRXZ, basename, subdirname, loadnumber);
    }

    public void write(String basename, double xmin, double xmax, double y, double zmin, int loadnumber) {
        Vector3d xzs = new Vector3d(xmin, y, zmin);
        Vector3d xze = new Vector3d(xmax, y, 0.0);
        ObservationPointData opdlocal = new ObservationPointData();
        ObservationPoint[][] gopXZ = ObservationPoint.getObservationPointArray(xzs, xze, ObservationPoint.IDIRXZ, 40, 40, opdlocal);
        this.final_u2u();
        this.calculateAll(opdlocal);
        ObservationPointData.outputPlane(gopXZ, ObservationPoint.IDIRXZ, basename, "XZdislocation", loadnumber);
    }

    public void stressUpdate(int i) {
        StressSource ss = this.get(i);
        ss.calculate(this.opd);
        ss.final_u.add(ss.u);
        ss.rupture_u.add(ss.u);
        ss.event_u.add(ss.u);
        ss.u.scale(0.0);
    }

    public void addSStoInspected(int inspect) {
        this.inspectedpatch[inspect] = this.Ninspected;
        this.inspectedpatch_ss_opd[this.Ninspected] = inspect;
        ++this.Ninspected;
        int index = 0;
        Vector3d temp = null;
        ObservationPoint op = this.opd.get(inspect);
        int i = 0;
        while (i < this.Ninspected - 1) {
            index = this.inspectedpatch_ss_opd[i];
            StressSource ss = this.get(index);
            temp = ss.u;
            ss.u = ss.rupture_u;
            ss.calculate(op);
            ss.u = temp;
            ++i;
        }
        this.updateTotalStressPF(inspect);
    }

    public void stressUpdateFastEndSeed() {
        int i = 0;
        while (i < this.size()) {
            if (this.indexevent[i] > -1) {
                StressSource ss = this.get(i);
                Vector3d temp = ss.u;
                ss.u = ss.rupture_u;
                ss.calculateNotInspected(this.opd, this.inspectedpatch);
                ss.u = temp;
            }
            ++i;
        }
    }

    public void stressUpdateFast(int i) {
        StressSource ss = this.get(i);
        ss.calculateInspected(this.opd, this.inspectedpatch_ss_opd, this.Ninspected);
        ss.final_u.add(ss.u);
        ss.event_u.add(ss.u);
        ss.rupture_u.add(ss.u);
        ss.u.scale(0.0);
    }

    public ObservationPoint[][] getObservationPointArray() {
        Vector3d xxs = this.opd.get((int)0).x;
        Vector3d xxe = this.opd.get((int)(this.nx * this.ny - 1)).x;
        int IDIR = ObservationPoint.IDIRXY;
        double[] dxdy = new double[2];
        double[] sxsy = new double[2];
        Vector3d stepX = new Vector3d();
        Vector3d stepY = new Vector3d();
        ObservationPoint.initializeStepXY(xxs, xxe, IDIR, this.nx, this.ny, stepX, stepY, sxsy, dxdy);
        ObservationPoint[][] gop = new ObservationPoint[this.nx][this.ny];
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                gop[i][j] = this.opd.get(i * this.ny + j);
                ++j;
            }
            ++i;
        }
        return gop;
    }

    public void setAseismic(double zmin, double zmax) {
        int i = 0;
        while (i < this.size()) {
            StressSource ss = this.get(i);
            if (ss.x.z > zmin && ss.x.z < zmax) {
                ss.sfric = ss.dfric + 0.01;
            }
            ++i;
        }
    }

    public void updatePressure(PressureWell pw, double qwell, double time, int icentral, int jcentral) {
        int ijcentral = this.getIseed(icentral, jcentral);
        double radius = 0.0;
        Vector3d center = this.get((int)ijcentral).x;
        Vector3d sub = new Vector3d();
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                int ij = this.getIseed(i, j);
                StressSource ss = this.get(ij);
                sub.sub(center, ss.x);
                radius = Math.max(1.0, sub.length());
                ss.pressure = 100000.0 * pw.getPressure(time, radius, qwell);
                ++j;
            }
            ++i;
        }
    }
}

