/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.PointSource;
import wrapper.SourceFactory;
import wrapper.StressSource;

public class StressTest {
    public static double E = 1.0E10;
    public static double v = 0.35;
    public static double THERMALEXPANSION = 5.4E-6;
    public static double REFTEMP = 200.0;
    static ObservationPointData observationPointData = new ObservationPointData();

    private static void setObservationPoints(double orx, int nx, double dx, double depth, double scale) {
        int i = 0;
        while (i < nx - 1) {
            Vector3d x = new Vector3d();
            x.x = orx + (double)i * dx;
            x.y = 0.0;
            x.z = depth;
            x.scale(scale);
            ObservationPoint op = new ObservationPoint(x);
            observationPointData.add(op);
            ++i;
        }
    }

    private static void setStressSources(double temperature, double r1, double r2, double depth, double dip, double kexpansion, double scale) {
        int nz = 1;
        double r0 = r1;
        double dx = r2 - r1;
        double nsteps = 18.0;
        double height = 1.0;
        r1 = r0;
        r2 = r1 + dx;
        double rsource = 0.5 * (r1 + r2);
        double areastep = Math.PI * (Math.pow(r2, 2.0) - Math.pow(r1, 2.0)) / nsteps;
        double dangle = Math.PI * 2 / nsteps;
        double angle = 0.0;
        double length = r2 - r1;
        double width = areastep / length;
        int ia = 0;
        while ((double)ia < nsteps) {
            angle = (double)ia * dangle;
            Vector3d x = new Vector3d();
            x.x = rsource * Math.cos(angle);
            x.y = rsource * Math.sin(angle);
            double azim = angle * 180.0 / Math.PI + 90.0;
            length = r2 - r1;
            int j = 0;
            while (j < nz) {
                Vector3d xx = new Vector3d(x);
                xx.z = depth;
                Vector3d u = new Vector3d();
                double volstrain = -(REFTEMP - temperature) * kexpansion;
                xx.scale(scale);
                SourceFactory.createSource(StressSource.SOURCE_POINT, xx, azim, dip, length *= scale, width *= scale, height *= scale, u, volstrain, true);
                ++j;
            }
            ++ia;
        }
    }

    public static void main(String[] args) {
        double coolingtemperature = 100.0;
        double depth = 1500.0;
        double dip = 0.0;
        double geometryscale = 1.0;
        double r1 = 0.0;
        double r2 = 200.0;
        PointSource.setStressParameters(E, v);
        StressTest.setStressSources(coolingtemperature, r1, r2, depth, dip, THERMALEXPANSION, geometryscale);
        int i = 1;
        while (i < 17) {
            StressTest.setObservationPoints(r1, 2, r2 - r1, depth, geometryscale);
            depth -= 99.9;
            ++i;
        }
        SourceFactory.getStressSourceData().calculateAll(observationPointData);
        observationPointData.output();
    }
}

