/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import okada.DCCON2;
import wrapper.StressSource;

public class TectonicStress
extends StressSource {
    public static double COHESION = 0.0;
    public static double SHMIN = 0.6;
    public static double SHMAX = 0.9;
    public static double ShminAzim = 90.0;
    static Matrix3d stress_change = new Matrix3d();
    static Vector3d normVector = new Vector3d();
    static Matrix3d sigma_tectonic = new Matrix3d();
    public static Vector3d vparalel = new Vector3d();
    public static Vector3d vperp = new Vector3d();
    static Matrix3d sigma = new Matrix3d();
    private static double[] press_coeff = new double[2];
    private static double PI8 = 0.01745329238474369;
    public static double HYDROSTAT = 10000.0;
    private static double rockdens = 2.3;
    public static double ss = 0.0;
    public static double sn = 0.0;
    public static double tow = 0.0;
    static float critstress = 0.0f;
    public static double CFF;
    public static double pf;
    public static int SFRICMODE;
    public static int DFRICMODE;
    private static Vector3d t;
    public static Vector3d initraction;
    private static Vector3d row;

    static {
        SFRICMODE = 1;
        DFRICMODE = 2;
        t = new Vector3d();
        initraction = null;
        row = new Vector3d();
    }

    public static Matrix3d TectStress(double sh, double sH, double azimsh, double rockdens, double depth) {
        sigma_tectonic = new Matrix3d();
        Matrix3d teta = new Matrix3d();
        TectonicStress.sigma_tectonic.m00 = sh;
        TectonicStress.sigma_tectonic.m11 = sH;
        TectonicStress.sigma_tectonic.m22 = 1.0;
        double rot = azimsh;
        teta.rotZ(1.5707963267948966 - Math.PI * 2 * rot / 360.0);
        Matrix3d tetaT = new Matrix3d(teta);
        tetaT.transpose();
        sigma_tectonic.mul(sigma_tectonic, tetaT);
        sigma_tectonic.mul(teta, sigma_tectonic);
        TectonicStress.press_coeff[0] = HYDROSTAT;
        TectonicStress.press_coeff[1] = 0.0;
        Matrix3d ts = new Matrix3d(sigma_tectonic);
        double p = -(press_coeff[0] * Math.abs(depth) + press_coeff[1]);
        ts.mul(rockdens * Math.abs(depth) * 9.8 * 1000.0);
        Matrix3d insitu_stress = new Matrix3d();
        insitu_stress.add(ts, new Matrix3d(p, 0.0, 0.0, 0.0, p, 0.0, 0.0, 0.0, p));
        return insitu_stress;
    }

    public static Vector3d getNormal(double azim, double dip) {
        Vector3d norm = new Vector3d();
        double ddip = 90.0 - dip;
        norm.z = -Math.sin(ddip * PI8);
        double rh = Math.cos(ddip * PI8);
        double rotradians = 1.5707963267948966 - azim * PI8;
        norm.x = Math.cos(rotradians) * rh;
        norm.y = Math.sin(rotradians) * rh;
        return norm;
    }

    public static Vector3d getT() {
        return t;
    }

    public static double stressCalculation(double azim, double dip, Matrix3d TotalStress, double fricangle, Vector3d norm, double pressure, double stressdrop) {
        critstress = 0.0f;
        sn = 0.0;
        ss = 0.0;
        pf = 0.0;
        double frictionangle = fricangle * PI8;
        double coh = COHESION;
        double ssdrop = stressdrop;
        if (norm == null) {
            norm = TectonicStress.getNormal(azim, dip);
            norm.scale(-1.0);
        }
        t = TectonicStress.getStress(norm, TotalStress, t);
        pf = TectonicStress.getProximityToFailure(t, norm, pressure, frictionangle, coh, ssdrop);
        double ratio = ss / sn;
        double dstressdrop = TectonicStress.getStressdrop2Failure(t, norm, pressure, frictionangle, coh, ssdrop);
        return dstressdrop;
    }

    public void StressDrop(Vector3d vperp, Vector3d vparalel, double sfricangle, double dfricangle, double G) {
        Vector3d u = new Vector3d();
        double inversemode = 1.0 / vparalel.length();
        u.scale(inversemode, vperp);
        double sn = vperp.length();
        double ss = vparalel.length();
        double myu = G;
        double stressdrop = sn * (Math.tan(sfricangle) - Math.tan(dfricangle)) / myu;
        Vector3d d = new Vector3d();
        d.scale(stressdrop, u);
    }

    public static double getProximityToFailure(Vector3d t, Vector3d norm, double p, double frictionangle, double c, double ssdrop) {
        sn = t.dot(norm);
        vperp.scale(sn, norm);
        vparalel.sub(t, vperp);
        ss = vparalel.length() - ssdrop;
        if (initraction == null) {
            initraction = new Vector3d(t);
        }
        if (initraction.dot(t) < 0.0) {
            ss = -ss;
        }
        if (Math.abs(sn -= p) > 0.001) {
            critstress = (float)(Math.tan(frictionangle) * sn + c);
            return (ss - (double)critstress) / (double)Math.abs(critstress);
        }
        if (c > 0.001) {
            return (ss - (double)critstress) / c;
        }
        return (ss - (double)critstress) / (double)Math.abs(critstress);
    }

    public static double getDcs(Matrix3d stress, double azim, double dip, double frictionangle) {
        Vector3d norm = TectonicStress.getNormal(azim, dip);
        norm.scale(-1.0);
        t = TectonicStress.getStress(norm, stress, t);
        sn = t.dot(norm);
        vperp.scale(sn, norm);
        vparalel.sub(t, vperp);
        ss = vparalel.length();
        if (initraction == null) {
            initraction = new Vector3d(t);
        }
        if (initraction.dot(t) < 0.0) {
            ss = -ss;
        }
        double dcs = ss - Math.tan(frictionangle * Math.PI / 180.0) * sn;
        return dcs;
    }

    public static double getStressdrop2Failure(Vector3d t, Vector3d norm, double p, double frictionangle, double c, double ssdrop) {
        sn = t.dot(norm);
        vperp.scale(sn, norm);
        vparalel.sub(t, vperp);
        ss = vparalel.length() - ssdrop;
        sn -= p;
        if (Math.abs(sn) > 0.001) {
            critstress = (float)(Math.tan(frictionangle) * sn + c);
            return ss - (double)critstress;
        }
        if (c > 0.001) {
            return ss - (double)critstress;
        }
        return ss - (double)critstress;
    }

    private static void ColoumbStressChange(double ShearChange, double normChange) {
        Matrix3d stressTensor = new Matrix3d(stress_change);
        double skk = stressTensor.m00 + stressTensor.m11 + stressTensor.m22;
        double k_skel = DCCON2.E / (3.0 * (1.0 - 2.0 * DCCON2.MYU));
        double kw = 22000.0;
        double a = 1.0 - k_skel / kw;
        double B = 1.0 / k_skel / (1.0 / k_skel + DCCON2.phi / a * (1.0 / kw));
        double u = 0.9;
        CFF = ShearChange + u * (normChange - B * skk / 3.0);
    }

    public static void getEig(Matrix3d mat, Vector3d p1, Vector3d p2, Vector3d p3, Vector3d eigval) {
        Matrix m = new Matrix(3, 3);
        m.set(0, 0, mat.m00);
        m.set(0, 1, mat.m01);
        m.set(0, 2, mat.m02);
        m.set(1, 0, mat.m10);
        m.set(1, 1, mat.m11);
        m.set(1, 2, mat.m12);
        m.set(2, 0, mat.m20);
        m.set(2, 1, mat.m21);
        m.set(2, 2, mat.m22);
        EigenvalueDecomposition eig = m.eig();
        Matrix mv = eig.getV();
        p1.x = mv.get(0, 0);
        p1.y = mv.get(1, 0);
        p1.z = mv.get(2, 0);
        p2.x = mv.get(0, 1);
        p2.y = mv.get(1, 1);
        p2.z = mv.get(2, 1);
        p3.x = mv.get(0, 2);
        p3.y = mv.get(1, 2);
        p3.z = mv.get(2, 2);
        double[] eigval2 = eig.getRealEigenvalues();
        eigval.x = eigval2[0];
        eigval.y = eigval2[1];
        eigval.z = eigval2[2];
    }

    public static double getST(Matrix3d stress, Vector3d normal, int bifsign, double frictionangle, Vector3d outputNormal) {
        Vector3d traction = new Vector3d();
        Vector3d p1 = new Vector3d();
        Vector3d p2 = new Vector3d();
        Vector3d p3 = new Vector3d();
        Vector3d eigval = new Vector3d();
        Vector3d svparalel = new Vector3d();
        Vector3d svperp = new Vector3d();
        Vector3d p3scale = new Vector3d();
        TectonicStress.getEig(stress, p1, p2, p3, eigval);
        if (normal == null) {
            normal = new Vector3d();
            double angle = Math.PI * (45.0 + 0.5 * frictionangle) / 180.0;
            double c = Math.cos((double)bifsign * angle);
            double s = Math.sin((double)bifsign * angle);
            normal.scale(c, p3);
            p3scale.scale(s, p1);
            normal.add(p3scale);
            outputNormal.x = normal.x;
            outputNormal.y = normal.y;
            outputNormal.z = normal.z;
        }
        TectonicStress.getStress(normal, stress, traction);
        double ssn = traction.dot(normal);
        svperp.scale(ssn, normal);
        svparalel.sub(traction, svperp);
        double sss = svparalel.length();
        return sss / ssn;
    }

    public static double getCoulombStress(Matrix3d stress, Vector3d normal, int bifsign, double frictionangle, Vector3d outputNormal) {
        double cs = 0.0;
        Vector3d traction = new Vector3d();
        Vector3d p1 = new Vector3d();
        Vector3d p2 = new Vector3d();
        Vector3d p3 = new Vector3d();
        Vector3d eigval = new Vector3d();
        Vector3d svparalel = new Vector3d();
        Vector3d svperp = new Vector3d();
        Vector3d p3scale = new Vector3d();
        TectonicStress.getEig(stress, p1, p2, p3, eigval);
        if (normal == null) {
            normal = new Vector3d();
            double angle = Math.PI * (45.0 + 0.5 * frictionangle) / 180.0;
            double c = Math.cos((double)bifsign * angle);
            double s = Math.sin((double)bifsign * angle);
            normal.scale(c, p3);
            p3scale.scale(s, p1);
            normal.add(p3scale);
            outputNormal.x = normal.x;
            outputNormal.y = normal.y;
            outputNormal.z = normal.z;
        }
        TectonicStress.getStress(normal, stress, traction);
        if (initraction == null) {
            initraction = new Vector3d(traction);
        }
        double sn = traction.dot(normal);
        Vector3d snvec = new Vector3d();
        snvec.scale(sn, normal);
        Vector3d ssvec = new Vector3d();
        ssvec.sub(traction, snvec);
        double sign = 1.0;
        if (initraction.dot(traction) < 0.0) {
            sign = -1.0;
        }
        double ss = ssvec.length() * sign;
        cs = ss - sn * Math.tan(frictionangle * Math.PI / 180.0);
        return cs;
    }

    public static Vector3d getStress(Vector3d norm, Matrix3d TotalStress, Vector3d v) {
        TectonicStress.press_coeff[1] = 0.0;
        Matrix3d sigma = TotalStress;
        if (v == null) {
            v = new Vector3d();
        }
        int i = 0;
        while (i < 3) {
            row.scale(0.0);
            sigma.getRow(i, row);
            double prod = row.dot(norm);
            switch (i) {
                case 0: {
                    v.x = prod;
                }
                case 1: {
                    v.y = prod;
                }
                case 2: {
                    v.z = prod;
                }
            }
            ++i;
        }
        return v;
    }
}

