/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.ObservationPointDataLine;
import wrapper.PointSource;
import wrapper.SetupSources;
import wrapper.SourceFactory;

public class TestCompaction {
    public static double E = 1.8E10;
    public static double v = 0.18;

    public static void testb() {
        ObservationPointData observationPointData = new ObservationPointData();
        String basename = "C:/Users/Public/wees/data/tests/okada/compaction/";
        double compaction = 0.16;
        double length = 2000.0;
        Vector3d xx = new Vector3d(0.0, 0.0, 2000.0);
        double x = xx.x;
        double y = xx.y;
        double depth = xx.z;
        int NXSOURCE = 100;
        int NYSOURCE = 100;
        double dxdy = length / (double)NXSOURCE;
        PointSource.setStressParameters(E, v);
        double GH = (1.0 - 2.0 * v) / (1.0 - v);
        SetupSources.setPointStressSources(x, y, depth, length, NXSOURCE, NYSOURCE, compaction, null, 0.0);
        int NX = 20;
        int NY = 20;
        double ddepth = 1.2 * dxdy / 2.0;
        Vector3d xys = new Vector3d(-dxdy, -dxdy, -2000.0 + ddepth);
        Vector3d xye = new Vector3d(dxdy, dxdy, -2000.0 + ddepth);
        ObservationPoint[][] gopXY1 = ObservationPoint.getObservationPointArray(xys, xye, ObservationPoint.IDIRXY, NX, NY, observationPointData);
        Vector3d xys2 = new Vector3d(-100.0, -100.0, -2000.0 - ddepth);
        Vector3d xye2 = new Vector3d(100.0, 100.0, -2000.0 - ddepth);
        ObservationPoint[][] gopXY2 = ObservationPoint.getObservationPointArray(xys2, xye2, ObservationPoint.IDIRXY, NX, NY, observationPointData);
        Vector3d xzs = new Vector3d(-2000.0, 0.0, -4000.0);
        Vector3d xze = new Vector3d(2000.0, 0.0, 0.0);
        ObservationPoint[][] gopXZ = ObservationPoint.getObservationPointArray(xzs, xze, ObservationPoint.IDIRXZ, NX, NY, observationPointData);
        SourceFactory.getStressSourceData().calculateAll(observationPointData);
        int loadnumber = 1;
        ObservationPointData.outputPlane(gopXY1, ObservationPoint.IDIRXY, basename, "XY", loadnumber);
        ObservationPointData.outputPlane(gopXY2, ObservationPoint.IDIRXY, basename, "XY", loadnumber);
        ObservationPointData.outputPlane(gopXZ, ObservationPoint.IDIRXZ, basename, "XZ", loadnumber);
        ObservationPointDataLine oplmidres = new ObservationPointDataLine("MIDRES_VERT", new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -3000.0), 25.0, 0.0, 0.0, 50.0, 50.0, 10);
        ObservationPointDataLine oplfault = new ObservationPointDataLine("EDGERES_VERT", new Vector3d(950.0, 0.0, -2025.0), new Vector3d(1050.0, 0.0, -2025.0), 1.0);
        SourceFactory.getStressSourceData().calculateAll(oplmidres);
        SourceFactory.getStressSourceData().calculateAll(oplfault);
        oplfault.output();
        oplmidres.output();
    }

    public static void main(String[] args) {
        TestCompaction.testb();
    }
}

