/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.logging.Level;
import javax.vecmath.Vector3d;
import logging.Logging;
import okada.DC3D0;
import tno.geoenergy.data.Grid;
import wrapper.FaultRoughness;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.PatchStack;
import wrapper.PointSource;
import wrapper.RectangularSource;
import wrapper.SetupSources;
import wrapper.SourceFactory;
import wrapper.StressSource;
import wrapper.StressSourceData;
import wrapper.StressSourceDataRupture;
import wrapper.TectonicStress;

public class TestDynamicRupture_Groningen {
    private static final int LINEAR = 0;
    private static final int SPHERICALCAP = 1;
    private static final int CONSTANT = 2;
    private static final boolean FOLLOWROUGHNESS = true;
    private static final double R = 1.0;
    private static final double BETA = 0.01;
    private static final int IMODE = 1;
    public static double E = 1.8E10;
    public static double v = 0.18;
    public static double GH = 0.0;
    public static double SHMIN = 0.7;
    public static double SHMAX = 0.9;
    public static int JSTART = 5;
    public static double NOISE_FRICTIONANGLE = 0.0;
    public static double NOISE_STRESSINCREMENT = 0.0;
    public static double NOISE_AZIM = 0.0;
    public static double NOISE_DIP = 0.0;
    public static double SFRIC = 34.0;
    public static double DFRIC = 31.0;
    public static double XSHIFT = 0.0;
    public static double ZSHIFT = 0.0;
    public static double MAXDIST = 8000.0;
    public static double COMPACTION = 0.16;
    public static int CALCMODE_SHEAR = 0;
    public static int CALCMODE_COMPACTION;
    public static int CALCMODE;
    public static int NOBSPLANE;
    public static double DXYCELL;

    static {
        CALCMODE = CALCMODE_COMPACTION = 1;
        NOBSPLANE = 6;
        DXYCELL = 50.0;
    }

    public static void setTectonicStress() {
        TectonicStress.SHMIN = SHMIN;
        TectonicStress.SHMAX = SHMAX;
    }

    public static Grid getCompactionLoad(double orx, double ory, double dx, double dy, int nx, int ny, String filename) {
        Grid g = DC3D0.getGrid(orx, ory, dx, dy, nx, ny, filename);
        return g;
    }

    public static void testb() {
        TestDynamicRupture_Groningen.setTectonicStress();
        ObservationPointData observationPointData = new ObservationPointData();
        String basename = "C:/Users/Public/wees/data/tests/okada/dynamicrupture_groningen/";
        double sfric = SFRIC;
        double dfric = DFRIC;
        double length = 4000.0;
        double width = 8000.0;
        double azim = 270.0;
        double dip = 63.5;
        double reservoirdepth = 2800.0;
        double reservoirthickness = 150.0;
        double depth = 4400.0;
        Vector3d u = new Vector3d();
        u.x = 0.0;
        u.y = 0.0;
        u.z = 0.0;
        int NX = (int)(length / DXYCELL);
        int NY = (int)(width / DXYCELL);
        RectangularSource.setStressParameters(E, v);
        PointSource.setStressParameters(E, v);
        Vector3d rupturePlane = new Vector3d(0.0, 0.0, depth);
        FaultRoughness fr = null;
        fr = SetupSources.setRectStressSources(rupturePlane.x, rupturePlane.y, rupturePlane.z, length, width, NX, NY, 0.0, azim, dip, u, StressSource.SOURCE_RECTANGULAR, null, 0.01, 1.0, 1, basename, true);
        System.out.println("----------------------- generated ruputure plane ------------------");
        StressSourceDataRupture ssdr = new StressSourceDataRupture(SourceFactory.getStressSourceData(), NX, NY, 0);
        ObservationPointData opd_rupture = ssdr.getObservationData();
        StressSourceDataRupture ssdrcopy = new StressSourceDataRupture(SourceFactory.getStressSourceData(), NX, NY, NOBSPLANE);
        ObservationPointData opd_rupture_copy = ssdrcopy.getObservationData();
        SourceFactory.getStressSourceData().clear();
        int NLOAD = 5000;
        int NLOAD2 = 5000;
        Vector3d ureservoir = new Vector3d(0.0, -COMPACTION, 0.0);
        double COMPACTFAC = 0.8;
        double lengthcompact = width * COMPACTFAC;
        double dxdycompact = 25.0;
        int NXCOMPACT = (int)(lengthcompact / dxdycompact);
        int NYCOMPACT = (int)(lengthcompact / dxdycompact);
        double orx = rupturePlane.x - lengthcompact;
        double ory = rupturePlane.y - lengthcompact / 2.0;
        double dx = lengthcompact / (double)NXCOMPACT;
        double dy = lengthcompact / (double)NYCOMPACT;
        Grid gload = DC3D0.getGrid(orx, ory, dx, dy, NXCOMPACT + 1, NYCOMPACT + 1, String.valueOf(basename) + "compaction.grd");
        TestDynamicRupture_Groningen.shapeGload(gload, 0, NXCOMPACT, NYCOMPACT / 2, (float)(COMPACTION / (double)NLOAD), 1, 1.0E38, 1.0E38);
        try {
            gload.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CALCMODE == CALCMODE_SHEAR) {
            ureservoir.scale(1.0 / (1.0 * (double)NLOAD));
            int j1 = JSTART;
            int j2 = NY - JSTART;
            System.out.println("j1 " + j1);
            SetupSources.setRectStressSourcesCopyRow(ssdr, NX, NY, NX / 2, NX / 2 + 1, j1, j2, ureservoir);
        } else if (CALCMODE == CALCMODE_COMPACTION) {
            SetupSources.setPointStressSourcesCompactAtZSplit(rupturePlane.x - 0.5 * lengthcompact, rupturePlane.y, rupturePlane.z, azim, dip, reservoirdepth, lengthcompact, lengthcompact, NXCOMPACT, NYCOMPACT, reservoirthickness, 1.0, gload, XSHIFT, fr, true, basename, 1);
        }
        System.out.println("----------------------- faults onreservoir ------------------");
        Vector3d reservoir = SourceFactory.getStressSourceData().get((int)(SourceFactory.getStressSourceData().size() - 1)).x;
        StressSourceData compaction_sources = new StressSourceData(SourceFactory.getStressSourceData());
        SourceFactory.getStressSourceData().clear();
        compaction_sources.calculateAll(opd_rupture_copy);
        ObservationPoint[][] gopRuptureRef = ssdrcopy.getObservationPointArray();
        int loadnumber = 1;
        ssdrcopy.setSfricDfricConstant(sfric, dfric);
        ssdrcopy.generateNoiseFriction(NOISE_FRICTIONANGLE);
        ssdrcopy.getTectonicStresses();
        ssdrcopy.setAllHealed();
        ssdrcopy.updateTotalStressPF();
        ObservationPointData.outputPlane(gopRuptureRef, ObservationPoint.IDIRXY, basename, "ruptureplanereference", loadnumber);
        ObservationPointData.outputPlane(gopRuptureRef, ObservationPoint.IDIRNORMAL, basename, "ruptureplanereference", loadnumber);
        observationPointData.clear();
        Vector3d xzs = new Vector3d(-1000.0, 0.0, -3300.0);
        Vector3d xze = new Vector3d(0.0, 0.0, -2300.0);
        ObservationPoint[][] gopXZ = ObservationPoint.getObservationPointArray(xzs, xze, ObservationPoint.IDIRXZ, 40, 40, observationPointData);
        compaction_sources.calculateAll(observationPointData);
        ObservationPointData.outputPlane(gopXZ, ObservationPoint.IDIRXZ, basename, "XZ", loadnumber);
        ssdr.getTectonicStresses();
        ObservationPoint[][] gopRupture = ssdr.getObservationPointArray();
        String subdir = "ruptureplane";
        double start = 0.0;
        ssdr.opd.incrementStressChange(opd_rupture_copy, start, 0.0);
        PatchStack ps = new PatchStack();
        int i = 0;
        while (i < NLOAD2) {
            System.out.println("------------ NEW loading step " + i + " ------------------");
            ssdr.opd.incrementStressChange(opd_rupture_copy, 1.0, NOISE_STRESSINCREMENT);
            ssdr.setAllHealed();
            ssdr.updateTotalStressPF();
            if (i == 0 || (i + 1) % 100 == 0) {
                ObservationPointData.outputPlane(gopRupture, ObservationPoint.IDIRNORMAL, basename, "ruptureplane", i);
            }
            ssdr.checkPfSeedStack(i, MAXDIST, ps);
            System.out.println("------------ STABELIZED STRESS  ------------------");
            System.out.println("---------- --END LOAD STEP " + i + " ------------------------");
            System.out.println();
            if ((i + 1) % 100 == 0) {
                ObservationPointData.outputPlane(gopRupture, ObservationPoint.IDIRNORMAL, basename, "ruptureplane_afterrupture", i);
                ssdr.writeSeismicEvents(0.0, 0.0, String.valueOf(basename) + i + "_");
            }
            ++i;
        }
        SourceFactory.getStressSourceData().clear();
        if (CALCMODE == CALCMODE_SHEAR) {
            ureservoir.scale(NLOAD);
            int j1 = JSTART;
            int j2 = NY - JSTART;
            System.out.println("j1 " + j1);
            SetupSources.setRectStressSourcesCopyRow(ssdr, NX, NY, NX / 2, NX / 2 + 1, j1, j2, ureservoir);
        } else if (CALCMODE == CALCMODE_COMPACTION) {
            SetupSources.setPointStressSourcesCompactAtZSplit(rupturePlane.x - 0.5 * lengthcompact, rupturePlane.y, rupturePlane.z, azim, dip, reservoirdepth, lengthcompact, lengthcompact, NXCOMPACT, NYCOMPACT, reservoirthickness, NLOAD2, gload, XSHIFT, fr, true, basename, 1);
        }
        ssdr.plotSectionXZ(basename, "XZdislocation", -2000.0, 2000.0, 0.0, -4000.0, 100, null);
        ssdr.plotSectionXZ(basename, "XZdislocationPLUSreservoir", -2000.0, 2000.0, 0.0, -4000.0, 100, SourceFactory.getStressSourceData());
    }

    private static void shapeGload(Grid g, int ipos1, int ipos2, int jpos, float maxval, int imode, double radius0, double radius) {
        int i = 0;
        while (i < g.nx) {
            int j = 0;
            while (j < g.ny) {
                double r = 1.0E20;
                r = i < ipos1 ? Math.pow(Math.pow((float)(i - ipos1) * g.dx, 2.0) + Math.pow((float)(j - jpos) * g.dy, 2.0), 0.5) : (i > ipos2 ? Math.pow(Math.pow((float)(i - ipos2) * g.dx, 2.0) + Math.pow((float)(j - jpos) * g.dy, 2.0), 0.5) : Math.pow(Math.pow((float)(j - jpos) * g.dy, 2.0), 0.5));
                if (r <= radius0) {
                    float[] fArray = g.values[i];
                    int n = j;
                    fArray[n] = fArray[n] + maxval;
                } else if (r < radius) {
                    if (imode == 2) {
                        float[] fArray = g.values[i];
                        int n = j;
                        fArray[n] = fArray[n] + maxval;
                    }
                    if (imode == 0) {
                        float[] fArray = g.values[i];
                        int n = j;
                        fArray[n] = fArray[n] + (float)((double)maxval * (1.0 - r / radius));
                    } else if (imode == 1) {
                        double startangle = 1.049291946298991;
                        double scale = 1.5707963267948966 - startangle;
                        double refy = Math.sin(startangle);
                        double scale2 = 1.0 / (1.0 - refy);
                        float[] fArray = g.values[i];
                        int n = j;
                        fArray[n] = fArray[n] + (float)((double)maxval * (Math.sin(1.5707963267948966 - scale * r / radius) - refy) * scale2);
                    }
                }
                ++j;
            }
            ++i;
        }
        g.determine_low_high();
    }

    public static void main(String[] args) {
        Logging.setLogHandler(Level.INFO);
        TestDynamicRupture_Groningen.testb();
    }
}

