/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.PointSource;
import wrapper.RectangularSource;
import wrapper.SetupSources;
import wrapper.SourceFactory;
import wrapper.StressSource;
import wrapper.StressSourceData;
import wrapper.StressSourceDataRupture;

public class TestHorizontalShearPf {
    public static double E = 1.0E10;
    public static double v = 0.35;
    public static double NOISE_FRICTIONANGLE = 0.0;
    public static double NOISE_STRESSINCREMENT = 0.0;
    public static double MINU = 1.0;
    public static double MAXU = 1.0;
    public static double SFRIC = 37.0;
    public static double DFRIC = 33.0;
    public static double MAXDIST = 2000.0;
    public static int NOBSPLANE = 6;

    public static void testb() {
        double lengthsource;
        ObservationPointData observationPointData = new ObservationPointData();
        String basename = "C:/Users/Public/wees/data/tests/okada/horizontalshear/";
        double sfric = 37.0;
        double dfric = 33.0;
        double length = 200.0;
        double width = 200.0;
        double azim = 90.0;
        double dip = 0.0;
        double depth = 2000.0;
        Vector3d u = new Vector3d();
        u.x = 0.0;
        u.y = 0.0;
        u.z = 0.0;
        int NX = 40;
        int NY = 40;
        RectangularSource.setStressParameters(E, v);
        PointSource.setStressParameters(E, v);
        Vector3d rupturePlane = new Vector3d(0.0, 0.0, depth);
        double length_width = 200.0;
        SetupSources.setRectStressSources(rupturePlane.x, rupturePlane.y, rupturePlane.z, length, width, NX, NY, 0.0, azim, dip, u, StressSource.SOURCE_RECTANGULAR);
        System.out.println("----------------------- generated ruputure plane ------------------");
        StressSourceDataRupture ssdr = new StressSourceDataRupture(SourceFactory.getStressSourceData(), NX, NY, NOBSPLANE);
        ObservationPointData opd_rupture = ssdr.getObservationData();
        StressSourceDataRupture ssdrcopy = new StressSourceDataRupture(SourceFactory.getStressSourceData(), NX, NY, NOBSPLANE);
        ObservationPointData opd_rupture_copy = ssdrcopy.getObservationData();
        SourceFactory.getStressSourceData().clear();
        Vector3d ureservoir = new Vector3d(0.0, 0.0, -1.0);
        double widthsource = lengthsource = 40.0;
        rupturePlane.z *= -1.0;
        SourceFactory.createSource(StressSource.SOURCE_RECTANGULAR, rupturePlane, azim, dip, lengthsource, widthsource, 0.0, ureservoir, 0.0, true);
        System.out.println("----------------------- faults onreservoir ------------------");
        Vector3d reservoir = SourceFactory.getStressSourceData().get((int)(SourceFactory.getStressSourceData().size() - 1)).x;
        StressSourceData compaction_sources = new StressSourceData(SourceFactory.getStressSourceData());
        SourceFactory.getStressSourceData().clear();
        SetupSources.setScale(compaction_sources, MINU, MAXU);
        compaction_sources.calculateAll(opd_rupture_copy);
        ObservationPoint[][] gopRuptureRef = ssdrcopy.getObservationPointArray();
        int loadnumber = 1;
        ssdrcopy.setSfricDfricConstant(sfric, dfric);
        ssdrcopy.generateNoiseFriction(NOISE_FRICTIONANGLE);
        ssdrcopy.getTectonicStresses();
        ssdrcopy.setAllHealed();
        ssdrcopy.updateTotalStressPF();
        ObservationPointData.outputPlane(gopRuptureRef, ObservationPoint.IDIRXY, basename, "ruptureplanereference", loadnumber);
        Vector3d xzs = new Vector3d(rupturePlane.x - 500.0, 0.0, rupturePlane.z - 500.0);
        Vector3d xze = new Vector3d(rupturePlane.x + 500.0, 0.0, rupturePlane.z + 500.0);
        ObservationPoint[][] gopXZ = ObservationPoint.getObservationPointArray(xzs, xze, ObservationPoint.IDIRXZ, 40, 40, observationPointData);
        compaction_sources.calculateAll(observationPointData);
        ObservationPointData.outputPlane(gopXZ, ObservationPoint.IDIRXZ, basename, "XZ", loadnumber);
    }

    public static void main(String[] args) {
        TestHorizontalShearPf.testb();
    }
}

