/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.PointSource;
import wrapper.RectangularSource;
import wrapper.SetupSources;
import wrapper.SourceFactory;
import wrapper.StressSource;
import wrapper.StressSourceData;
import wrapper.StressSourceDataRupture;

public class TestMultipleLoad {
    public static double E = 1.0E10;
    public static double v = 0.35;
    public static int NOBSPLANE = 6;

    public static void testRect(int NLOAD, boolean pointsource, boolean plotsection) {
        ObservationPointData observationPointData = new ObservationPointData();
        String basename = "C:/Users/Public/wees/data/tests/okada/multipleload/";
        double sfric = 37.0;
        double dfric = 33.0;
        double length = 2000.0;
        double width = 2000.0;
        double azim = 90.0;
        double dip = 60.0;
        double depth = 2000.0;
        Vector3d u = new Vector3d();
        u.x = 0.0;
        u.y = 0.0;
        u.z = 0.0;
        int NX = 3;
        int NY = 3;
        RectangularSource.setStressParameters(E, v);
        PointSource.setStressParameters(E, v);
        Vector3d rupturePlane = new Vector3d(0.0, 0.0, depth);
        double length_width = 2000.0;
        SetupSources.setRectStressSources(rupturePlane.x, rupturePlane.y, rupturePlane.z, length_width, length_width, NX, NY, 0.0, azim, dip, u, StressSource.SOURCE_RECTANGULAR);
        StressSourceDataRupture ssdr = new StressSourceDataRupture(SourceFactory.getStressSourceData(), NX, NY, NOBSPLANE);
        ObservationPointData opd_rupture = ssdr.getObservationData();
        StressSourceDataRupture ssdrcopy = new StressSourceDataRupture(SourceFactory.getStressSourceData(), NX, NY, NOBSPLANE);
        ObservationPointData opd_rupture_copy = ssdrcopy.getObservationData();
        SourceFactory.getStressSourceData().clear();
        Vector3d reservoir = new Vector3d(-500.0, 0.0, depth);
        length_width = 950.0;
        NY = 27;
        NX = 27;
        double compaction = 1.0;
        if (pointsource) {
            SetupSources.setPointStressSources(reservoir.x, reservoir.y, reservoir.z, length_width, NX, NY, compaction, null, 0.0);
        } else {
            u.y = 0.1;
            SetupSources.setRectStressSources(reservoir.x, reservoir.y, reservoir.z, length_width, length_width, NX, NY, 0.0, 90.0, 0.0, u, StressSource.SOURCE_RECTANGULAR);
        }
        StressSourceData compaction_sources = new StressSourceData(SourceFactory.getStressSourceData());
        compaction_sources.calculateAll(opd_rupture_copy);
        ObservationPoint[][] gopRuptureRef = ssdrcopy.getObservationPointArray();
        int loadnumber = 1;
        if (plotsection) {
            Vector3d xzs = new Vector3d(-2000.0, 0.0, -4000.0);
            Vector3d xze = new Vector3d(2000.0, 0.0, 0.0);
            ObservationPoint[][] gopXZ = ObservationPoint.getObservationPointArray(xzs, xze, ObservationPoint.IDIRXZ, 40, 40, observationPointData);
            compaction_sources.calculateAll(observationPointData);
            ObservationPointData.outputPlane(gopXZ, ObservationPoint.IDIRXZ, basename, "XZ", loadnumber);
        } else {
            compaction_sources.calculateAll(observationPointData);
        }
        ObservationPointData.outputPlane(gopRuptureRef, ObservationPoint.IDIRXY, basename, "ruptureplanereference", loadnumber);
        SourceFactory.getStressSourceData().calculateAll(observationPointData);
        SourceFactory.getStressSourceData().clear();
        ssdr.calculateAll(opd_rupture);
        ssdr.setSfricDfricConstant(sfric, dfric);
        ssdr.getTectonicStresses();
        ObservationPoint[][] gopRupture = ssdr.getObservationPointArray();
        String subdir = "ruptureplane";
        int i = 0;
        while (i < NLOAD) {
            ssdr.opd.incrementStressChange(opd_rupture_copy, 1.0 / (double)NLOAD, 0.0);
            ssdr.setAllHealed();
            ssdr.updateTotalStressPF();
            ssdr.checkPf(0);
            ObservationPointData.outputPlane(gopRupture, ObservationPoint.IDIRXY, basename, "ruptureplane", i);
            ++i;
        }
    }

    public static void main(String[] args) {
        boolean pointsource = true;
        boolean plotsection = true;
        int NLOAD = 1;
        TestMultipleLoad.testRect(NLOAD, !pointsource, !plotsection);
    }
}

