/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.logging.Level;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import logging.Logging;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.PatchStack;
import wrapper.PointSource;
import wrapper.PressureWell;
import wrapper.RectangularSource;
import wrapper.SetupSources;
import wrapper.SourceFactory;
import wrapper.StressSource;
import wrapper.StressSourceDataRupture;

public class TestPressureDiffussion {
    public static double E = 1.0E10;
    public static double v = 0.35;
    public static int JSTART = 5;
    public static int RANDOMSEED = 1;
    public static int NOBSPLANE = 6;
    public static double NOISE_FRICTIONANGLE = 2.0;
    public static double SFRIC = 41.0;
    public static double DFRIC = 40.0;
    public static double MAXDIST = 2000.0;
    public static int CALCMODE_PRESSURE;
    public static int CALCMODE;

    static {
        CALCMODE = CALCMODE_PRESSURE = 1;
    }

    public static void testb() {
        ObservationPointData observationPointData = new ObservationPointData();
        String basename = "C:/Users/Public/wees/data/tests/okada/pressure/";
        double sfric = SFRIC;
        double dfric = DFRIC;
        double length = 1200.0;
        double width = 1200.0;
        double azim = 90.0;
        double dip = 63.5;
        double depth = 5000.0;
        Vector3d u = new Vector3d();
        u.x = 0.0;
        u.y = 0.0;
        u.z = 0.0;
        int NX = 60;
        int NY = 60;
        RectangularSource.setStressParameters(E, v);
        PointSource.setStressParameters(E, v);
        Vector3d rupturePlane = new Vector3d(0.0, 0.0, depth);
        SetupSources.setRectStressSources(rupturePlane.x, rupturePlane.y, rupturePlane.z, length, width, NX, NY, 0.0, azim, dip, u, StressSource.SOURCE_RECTANGULAR);
        System.out.println("----------------------- generated ruputure plane ------------------");
        StressSourceDataRupture ssdr = new StressSourceDataRupture(SourceFactory.getStressSourceData(), NX, NY, NOBSPLANE);
        SourceFactory.getStressSourceData().clear();
        int NLOAD = 3600;
        int DLOAD = 1;
        double endtime = 1.0;
        double Qwell = 0.0;
        Matrix3d deltaStress = new Matrix3d();
        if (CALCMODE == CALCMODE_PRESSURE) {
            Qwell = 50.0;
            endtime = 50.0;
            NLOAD = (int)((double)NLOAD * (endtime / (double)DLOAD));
        }
        System.out.println("----------------------- faults onreservoir ------------------");
        int iran = 0;
        while (iran < 1) {
            ssdr.setSfricDfricConstant(sfric, dfric);
            ssdr.generateNoiseFriction(NOISE_FRICTIONANGLE);
            ssdr.getTectonicStresses();
            ssdr.opd.clearOutput();
            ObservationPoint[][] gopRupture = ssdr.getObservationPointArray();
            String subdir = "ruptureplane";
            double start = 0.0;
            PatchStack ps = new PatchStack();
            PressureWell pw = PressureWell.getTypicalWell();
            int icentral = NX / 2;
            int jcentral = NY / 2;
            int i = 0;
            while (i < NLOAD) {
                System.out.println("------------ NEW loading step " + i + " ------------------");
                double time = (double)(i * DLOAD) / endtime;
                ssdr.updatePressure(pw, Qwell, time, icentral, jcentral);
                ssdr.setAllHealed();
                ssdr.updateTotalStressPF();
                if (i == 0 || (i * DLOAD + 1) % 3600 == 0) {
                    ObservationPointData.outputPlane(gopRupture, ObservationPoint.IDIRXY, basename, "ruptureplane", (i * DLOAD + 1) / 3600);
                }
                ssdr.checkPfSeedStack(i, MAXDIST, ps);
                System.out.println("------------ STABELIZED STRESS  ------------------");
                System.out.println("---------- --END LOAD STEP " + i + " ------------------------");
                System.out.println();
                if ((i * DLOAD + 1) % 3600 == 0) {
                    ObservationPointData.outputPlane(gopRupture, ObservationPoint.IDIRXY, basename, "ruptureplane_afterrupture", i);
                    ssdr.writeSeismicEvents(0.0, 0.0, String.valueOf(basename) + (i * DLOAD + 1) / 3600 + "_");
                }
                ++i;
            }
            ssdr.plotSectionXZ(basename, "XZdislocation", -1000.0, 1000.0, -4000.0, -6000.0, 20, null);
            ++iran;
        }
    }

    public static void main(String[] args) {
        Logging.setLogHandler(Level.FINE);
        TestPressureDiffussion.testb();
    }
}

