/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.logging.Level;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import logging.Logging;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.PatchStack;
import wrapper.PointSource;
import wrapper.RectangularSource;
import wrapper.SetupSources;
import wrapper.SourceFactory;
import wrapper.StressSource;
import wrapper.StressSourceDataRupture;

public class TestTectonicRuptureNew {
    public static double E = 1.0E10;
    public static double v = 0.35;
    public static int JSTART = 5;
    public static int RANDOMSEED = 1;
    public static double NOISE_STRESSINCREMENT = 0.0;
    public static double MINU = 1.0;
    public static double MAXU = 1.0;
    public static double NOISE_FRICTIONANGLE1 = 3.0;
    public static double NOISE_FRICTIONANGLE2 = 2.0;
    public static double SFRIC1 = 36.1;
    public static double SFRIC2 = 35.6;
    public static double NOISE_FRICTIONANGLE = 2.0;
    public static double SFRIC = 35.6;
    public static double DFRIC = 34.6;
    public static double MAXDIST = 20000.0;
    public static int CALCMODE_EXTENSION;
    public static int CALCMODE;
    public static int NOBSPLANE;

    static {
        CALCMODE = CALCMODE_EXTENSION = 1;
        NOBSPLANE = 6;
    }

    public static void testb() {
        ObservationPointData observationPointData = new ObservationPointData();
        String basename = "C:/Users/Public/wees/data/tests/okada/tectonicrupture/";
        double sfric = SFRIC;
        double dfric = DFRIC;
        double length = 12000.0;
        double width = 12000.0;
        double azim = 90.0;
        double dip = 63.5;
        double depth = 11000.0;
        Vector3d u = new Vector3d();
        u.x = 0.0;
        u.y = 0.0;
        u.z = 0.0;
        int NX = 30;
        int NY = 30;
        RectangularSource.setStressParameters(E, v);
        PointSource.setStressParameters(E, v);
        Vector3d rupturePlane = new Vector3d(0.0, 0.0, depth);
        SetupSources.setRectStressSources(rupturePlane.x, rupturePlane.y, rupturePlane.z, length, width, NX, NY, 0.0, azim, dip, u, StressSource.SOURCE_RECTANGULAR);
        System.out.println("----------------------- generated ruputure plane ------------------");
        StressSourceDataRupture ssdr = new StressSourceDataRupture(SourceFactory.getStressSourceData(), NX, NY, NOBSPLANE);
        SourceFactory.getStressSourceData().clear();
        int NLOAD = 50000;
        Matrix3d deltaStress = new Matrix3d();
        if (CALCMODE == CALCMODE_EXTENSION) {
            double totalload = -2.0;
            deltaStress.m00 = totalload * 1000000.0;
            deltaStress.mul(-1.0 / (double)NLOAD);
        }
        System.out.println("----------------------- faults onreservoir ------------------");
        int iran = 0;
        while (iran < 1) {
            ssdr.setSfricDfricConstant(sfric, dfric);
            ssdr.generateNoiseFriction(NOISE_FRICTIONANGLE1, NOISE_FRICTIONANGLE2, SFRIC1, SFRIC2);
            ssdr.getTectonicStresses();
            ssdr.opd.clearOutput();
            ObservationPoint[][] gopRupture = ssdr.getObservationPointArray();
            String subdir = "ruptureplane";
            double start = 0.0;
            PatchStack ps = new PatchStack();
            ssdr.opd.incrementTectonicStress(deltaStress, start * (double)NLOAD);
            int i = 0;
            while (i < NLOAD) {
                System.out.println("------------ NEW loading step " + i + " ------------------");
                ssdr.opd.incrementTectonicStress(deltaStress, 1.0);
                ssdr.setAllHealed();
                ssdr.updateTotalStressPF();
                if (i == 0 || (i + 1) % 1000 == 0) {
                    ObservationPointData.outputPlane(gopRupture, ObservationPoint.IDIRXY, basename, "ruptureplane", i);
                }
                ssdr.checkPfSeedStack(i, MAXDIST, ps);
                System.out.println("------------ STABELIZED STRESS  ------------------");
                System.out.println("---------- --END LOAD STEP " + i + " ------------------------");
                System.out.println();
                if ((i + 1) % 1000 == 0) {
                    ObservationPointData.outputPlane(gopRupture, ObservationPoint.IDIRXY, basename, "ruptureplane_afterrupture", i);
                    ssdr.writeSeismicEvents(0.0, 0.0, String.valueOf(basename) + i + "_");
                }
                ++i;
            }
            ssdr.plotSectionXZ(basename, "XZdislocation", -10000.0, 10000.0, 0.0, -15000.0, 100, null);
            ++iran;
        }
    }

    public static void main(String[] args) {
        Logging.setLogHandler(Level.FINE);
        TestTectonicRuptureNew.testb();
    }
}

