/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.logging.Level;
import javax.vecmath.Vector3d;
import logging.Logging;
import okada.DC3D0;
import tno.geoenergy.data.Grid;
import wrapper.FaultRoughness;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.ObservationPointDataLine;
import wrapper.PatchStack;
import wrapper.PointSource;
import wrapper.RectangularSource;
import wrapper.SetupSources;
import wrapper.SourceFactory;
import wrapper.StressSource;
import wrapper.StressSourceData;
import wrapper.StressSourceDataRupture;
import wrapper.TectonicStress;

public class Test_differential_compaction_midfault {
    private static final int LINEAR = 0;
    private static final int SPHERICALCAP = 1;
    private static final int CONSTANT = 2;
    private static final boolean FOLLOWROUGHNESS = true;
    private static final double R = 1.0;
    private static final double BETA = 0.01;
    private static final int IMODE = 1;
    public static double E = 1.8E10;
    public static double v = 0.18;
    public static int NOBSPLANE = 6;
    public static double SHMIN = 0.64;
    public static double SHMAX = 0.9;
    public static double ShminAzim = 90.0;
    public static int JSTART = 5;
    public static double NOISE_FRICTIONANGLE = 0.0;
    public static double NOISE_STRESSINCREMENT = 0.0;
    public static double NOISE_AZIM = 0.0;
    public static double NOISE_DIP = 0.0;
    public static double SFRIC = 32.0;
    public static double DFRIC = 29.99;
    public static double COHESION = 0.0;
    public static double XSHIFT = 0.0;
    public static double ZSHIFT = 0.0;
    public static double MAXDIST = 8000.0;
    public static double COMPACTION = 0.15;
    public static int CALCMODE_SHEAR = 0;
    public static int CALCMODE_COMPACTION;
    public static int CALCMODE;
    public static double MWTRESHOLD;
    public static double DXYCELL;

    static {
        CALCMODE = CALCMODE_COMPACTION = 1;
        MWTRESHOLD = -0.5;
        DXYCELL = 25.0;
    }

    public static void setTectonicStress() {
        TectonicStress.SHMIN = SHMIN;
        TectonicStress.SHMAX = SHMAX;
        TectonicStress.ShminAzim = ShminAzim;
        TectonicStress.COHESION = COHESION;
    }

    public static Grid getCompactionLoad(double orx, double ory, double dx, double dy, int nx, int ny, String filename) {
        Grid g = DC3D0.getGrid(orx, ory, dx, dy, nx, ny, filename);
        return g;
    }

    public static void testb() {
        Test_differential_compaction_midfault.setTectonicStress();
        StressSourceDataRupture.setMWTRESHOLD(MWTRESHOLD);
        ObservationPointData observationPointData = new ObservationPointData();
        String basename = "C:/Users/Public/wees/data/tests/okada/differential_compaction/";
        double sfric = SFRIC;
        double dfric = DFRIC;
        double length = 2000.0;
        double width = 2000.0;
        double azim = 270.0;
        double dip = 70.0;
        double reservoirdepth = 2800.0;
        double reservoirthickness = 150.0;
        double depth = 2800.0;
        Vector3d u = new Vector3d();
        u.x = 0.0;
        u.y = 0.0;
        u.z = 0.0;
        int NX = (int)(length / DXYCELL);
        int NY = (int)(width / DXYCELL);
        RectangularSource.setStressParameters(E, v);
        PointSource.setStressParameters(E, v);
        Vector3d rupturePlane = new Vector3d(0.0, 0.0, depth);
        FaultRoughness fr = null;
        fr = SetupSources.setRectStressSources(rupturePlane.x, rupturePlane.y + 7.0, rupturePlane.z, length, width, NX, NY, 0.0, azim, dip, u, StressSource.SOURCE_RECTANGULAR, null, 0.01, 1.0, 1, basename, true);
        System.out.println("----------------------- generated ruputure plane ------------------");
        StressSourceDataRupture ssdr = new StressSourceDataRupture(SourceFactory.getStressSourceData(), NX, NY, 0);
        ObservationPointData opd_rupture = ssdr.getObservationData();
        StressSourceDataRupture ssdrcopy = new StressSourceDataRupture(SourceFactory.getStressSourceData(), NX, NY, NOBSPLANE);
        ObservationPointData opd_ssdrcopy = ssdrcopy.getObservationData();
        SourceFactory.getStressSourceData().clear();
        int NLOAD = 5000;
        int NLOAD2 = 5000;
        Vector3d ureservoir = new Vector3d(0.0, -COMPACTION, 0.0);
        double COMPACTFAC = 0.5;
        double lengthcompact = width * COMPACTFAC;
        double dxdycompact = 25.0;
        int NXCOMPACT = (int)(lengthcompact / dxdycompact);
        int NYCOMPACT = (int)(lengthcompact / dxdycompact);
        double orx = rupturePlane.x - lengthcompact;
        double ory = rupturePlane.y - lengthcompact / 2.0;
        double dx = lengthcompact / (double)NXCOMPACT;
        double dy = lengthcompact / (double)NYCOMPACT;
        Grid gload = DC3D0.getGrid(orx, ory, dx, dy, NXCOMPACT + 1, NYCOMPACT + 1, String.valueOf(basename) + "compaction.grd");
        Test_differential_compaction_midfault.shapeGload(gload, 0, NXCOMPACT, NYCOMPACT / 2, (float)(COMPACTION / (double)NLOAD), 1, 5000.0, lengthcompact / 2.0);
        try {
            gload.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CALCMODE == CALCMODE_COMPACTION) {
            SetupSources.setPointStressSourcesCompactAtZSplit(rupturePlane.x - 0.5 * lengthcompact, rupturePlane.y, rupturePlane.z, azim, dip, reservoirdepth, lengthcompact, lengthcompact, NXCOMPACT, NYCOMPACT, reservoirthickness, 1.0, gload, XSHIFT, fr, true, basename, 1);
        }
        System.out.println("----------------------- faults onreservoir ------------------");
        StressSourceData compaction_sources = new StressSourceData(SourceFactory.getStressSourceData());
        SourceFactory.getStressSourceData().clear();
        opd_ssdrcopy.clearOutput();
        compaction_sources.calculateAll(opd_ssdrcopy);
        ObservationPoint[][] gopRuptureRef = ssdrcopy.getObservationPointArray();
        int loadnumber = 1;
        ssdrcopy.setSfricDfricConstant(sfric, dfric);
        ssdrcopy.generateNoiseFriction(0.0);
        ssdrcopy.getTectonicStresses();
        ssdrcopy.setAllHealed();
        ssdrcopy.updateTotalStressPF();
        ObservationPointData.outputPlane(gopRuptureRef, ObservationPoint.IDIRXY, basename, "ruptureplanereference", loadnumber);
        ObservationPointData.outputPlane(gopRuptureRef, ObservationPoint.IDIRNORMAL, basename, "ruptureplanereference", loadnumber);
        observationPointData.clear();
        Vector3d xzs = new Vector3d(-800.0, 0.0, -3300.0);
        Vector3d xze = new Vector3d(800.0, 0.0, -2300.0);
        ObservationPoint[][] gopXZ = ObservationPoint.getObservationPointArray(xzs, xze, ObservationPoint.IDIRXZ, 40, 40, observationPointData);
        compaction_sources.calculateAll(observationPointData);
        double resmiddepth = -reservoirdepth + 0.5 * reservoirthickness;
        ObservationPointDataLine oplmidres = new ObservationPointDataLine("MIDRES_VERT", new Vector3d(-lengthcompact / 2.0, 0.0, -reservoirdepth - 200.0), new Vector3d(-lengthcompact / 2.0, 0.0, 0.0), 50.0);
        ObservationPointDataLine oplfaultver = new ObservationPointDataLine("FAULT_VERT", new Vector3d(0.0, 0.0, resmiddepth - 200.0), new Vector3d(0.0, 0.0, resmiddepth + 200.0), 1.0);
        ObservationPointDataLine oplfaultver2 = new ObservationPointDataLine("FAULT_VERT2", new Vector3d(0.0, 5.0, resmiddepth - 200.0), new Vector3d(0.0, 0.0, resmiddepth + 200.0), 1.0);
        ObservationPointDataLine oplfault = new ObservationPointDataLine("FAULT_HOR", new Vector3d(0.0, 0.0, resmiddepth), new Vector3d(500.0, 0.0, resmiddepth), 20.0, 270.0, 90.0, 50.0, 50.0, 10);
        ObservationPointDataLine oplfault2 = new ObservationPointDataLine("FAULT_HOR2", new Vector3d(-250.0, 250.0, resmiddepth), new Vector3d(-250.0, 750.0, resmiddepth), 20.0, 270.0, 90.0, 50.0, 50.0, 10);
        ObservationPointData.outputPlane(gopXZ, ObservationPoint.IDIRXZ, basename, "XZ", loadnumber);
        ssdr.setSfricDfricConstant(sfric, dfric);
        ssdr.generateNoiseFriction(NOISE_FRICTIONANGLE);
        ssdr.getTectonicStresses();
        ObservationPoint[][] gopRupture = ssdr.getObservationPointArray();
        String subdir = "ruptureplane";
        double start = 0.0;
        ssdr.opd.incrementStressChange(opd_ssdrcopy, start, 0.0);
        PatchStack ps = new PatchStack();
        int i = 0;
        while (i < NLOAD2) {
            System.out.println("------------ NEW loading step " + i + " ------------------");
            ssdr.opd.incrementStressChange(opd_ssdrcopy, 1.0, NOISE_STRESSINCREMENT);
            ssdr.setAllHealed();
            ssdr.updateTotalStressPF();
            if (i == 0 || (i + 1) % (NLOAD / 10) == 0) {
                ObservationPointData.outputPlane(gopRupture, ObservationPoint.IDIRNORMAL, basename, "ruptureplane", i);
            }
            ssdr.checkPfSeedStack(i, MAXDIST, ps);
            System.out.println("------------ STABELIZED STRESS  ------------------");
            System.out.println("---------- --END LOAD STEP " + i + " ------------------------");
            System.out.println();
            if ((i + 1) % (NLOAD / 10) == 0) {
                ObservationPointData.outputPlane(gopRupture, ObservationPoint.IDIRNORMAL, basename, "ruptureplane_afterrupture", i);
                ssdr.writeSeismicEvents(0.0, 0.0, String.valueOf(basename) + i + "_");
            }
            ++i;
        }
        if (CALCMODE == CALCMODE_COMPACTION) {
            SetupSources.setPointStressSourcesCompactAtZSplit(rupturePlane.x - 0.5 * lengthcompact, rupturePlane.y, rupturePlane.z, azim, dip, reservoirdepth, lengthcompact, lengthcompact, NXCOMPACT, NYCOMPACT, reservoirthickness, NLOAD, gload, XSHIFT, fr, true, basename, 1);
        }
        ssdr.plotSectionXZ(basename, "XZdislocation", -2000.0, 2000.0, 0.0, -4000.0, 100, null);
        ssdr.plotSectionXZ(basename, "XZdislocationPLUSreservoir", -2000.0, 2000.0, 0.0, -4000.0, 100, SourceFactory.getStressSourceData());
        SourceFactory.getStressSourceData().calculateAll(oplmidres);
        SourceFactory.getStressSourceData().calculateAll(oplfault);
        SourceFactory.getStressSourceData().calculateAll(oplfault2);
        SourceFactory.getStressSourceData().calculateAll(oplfaultver);
        SourceFactory.getStressSourceData().calculateAll(oplfaultver2);
        oplmidres.output();
        oplfaultver.output();
        oplfaultver2.output();
        oplfault.output();
        oplfault2.output();
        oplmidres.clearOutput();
        oplfault.clearOutput();
        oplfault2.clearOutput();
        oplfaultver.clearOutput();
        oplfaultver2.clearOutput();
    }

    private static void shapeGload(Grid g, int ipos1, int ipos2, int jpos, float maxval, int imode, double radius0, double radius) {
        int i = 0;
        while (i < g.nx) {
            int j = 0;
            while (j < g.ny) {
                double r = 1.0E20;
                r = i < ipos1 ? Math.pow(Math.pow((float)(i - ipos1) * g.dx, 2.0) + Math.pow((float)(j - jpos) * g.dy, 2.0), 0.5) : (i > ipos2 ? Math.pow(Math.pow((float)(i - ipos2) * g.dx, 2.0) + Math.pow((float)(j - jpos) * g.dy, 2.0), 0.5) : Math.pow(Math.pow((float)(j - jpos) * g.dy, 2.0), 0.5));
                if (r <= radius0) {
                    float[] fArray = g.values[i];
                    int n = j;
                    fArray[n] = fArray[n] + maxval;
                } else if (r < radius) {
                    if (imode == 2) {
                        float[] fArray = g.values[i];
                        int n = j;
                        fArray[n] = fArray[n] + maxval;
                    }
                    if (imode == 0) {
                        float[] fArray = g.values[i];
                        int n = j;
                        fArray[n] = fArray[n] + (float)((double)maxval * (1.0 - r / radius));
                    } else if (imode == 1) {
                        double startangle = 1.049291946298991;
                        double scale = 1.5707963267948966 - startangle;
                        double refy = Math.sin(startangle);
                        double scale2 = 1.0 / (1.0 - refy);
                        float[] fArray = g.values[i];
                        int n = j;
                        fArray[n] = fArray[n] + (float)((double)maxval * (Math.sin(1.5707963267948966 - scale * r / radius) - refy) * scale2);
                    }
                }
                ++j;
            }
            ++i;
        }
        g.determine_low_high();
    }

    public static void main(String[] args) {
        Logging.setLogHandler(Level.INFO);
        Test_differential_compaction_midfault.testb();
    }
}

